/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringUtil;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HourglassTrigger;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class HoveringHourglassBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements ManaTrigger,
Wandable {
    private static final String TAG_TIME = "time";
    private static final String TAG_TIME_FRACTION = "timeFraction";
    private static final String TAG_FLIP = "flip";
    private static final String TAG_FLIP_TICKS = "flipTicks";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_MOVE = "move";
    private int time = 0;
    public float timeFraction = 0.0f;
    public float lastFraction = 0.0f;
    public boolean flip = false;
    public int flipTicks = 0;
    public boolean lock = false;
    public boolean move = true;

    public HoveringHourglassBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.HOURGLASS, pos, state);
    }

    private boolean isDust() {
        ItemStack stack = this.getItemHandler().getItem(0);
        return !stack.isEmpty() && stack.is(BotaniaItems.manaPowder);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, HoveringHourglassBlockEntity self) {
        int totalTime = self.getTotalTime();
        boolean dust = self.isDust();
        if (totalTime > 0 || dust) {
            if (self.move && !dust) {
                ++self.time;
            }
            if (self.time >= totalTime) {
                self.time = 0;
                self.flip = !self.flip;
                self.flipTicks = 4;
                if (!level.isClientSide) {
                    level.setBlock(worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)), 1);
                    level.scheduleTick(worldPosition, state.getBlock(), 4);
                }
                for (Direction facing : Direction.values()) {
                    BlockPos pos = worldPosition.relative(facing);
                    HourglassTrigger trigger = XplatAbstractions.INSTANCE.findHourglassTrigger(level, pos, level.getBlockState(pos), level.getBlockEntity(pos));
                    if (trigger == null) continue;
                    trigger.onTriggeredByHourglass(self);
                }
            }
            self.lastFraction = self.timeFraction;
            self.timeFraction = (float)self.time / (float)totalTime;
        } else {
            self.time = 0;
            self.lastFraction = 0.0f;
            self.timeFraction = 0.0f;
        }
        if (self.flipTicks > 0) {
            --self.flipTicks;
        }
    }

    @Override
    public void onBurstCollision(ManaBurst burst) {
        if (!this.level.isClientSide && !burst.isFake()) {
            if (this.isDust()) {
                ++this.time;
            } else {
                this.move = !this.move;
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.getItemHandler().getItem(0);
        if (stack.isEmpty()) {
            return 0;
        }
        return HoveringHourglassBlockEntity.getStackItemTime(stack) * stack.getCount();
    }

    public static int getStackItemTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.is(Blocks.SAND.asItem())) {
            return 20;
        }
        if (stack.is(Blocks.RED_SAND.asItem())) {
            return 200;
        }
        if (stack.is(Blocks.SOUL_SAND.asItem())) {
            return 1200;
        }
        if (stack.is(BotaniaItems.manaPowder)) {
            return 1;
        }
        return 0;
    }

    public int getColor() {
        ItemStack stack = this.getItemHandler().getItem(0);
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.is(Blocks.SAND.asItem())) {
            return 16772169;
        }
        if (stack.is(Blocks.RED_SAND.asItem())) {
            return 15292416;
        }
        if (stack.is(Blocks.SOUL_SAND.asItem())) {
            return 5914927;
        }
        if (stack.is(BotaniaItems.manaPowder)) {
            return 240639;
        }
        return 0;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean canPlaceItem(int index, ItemStack stack) {
                return !stack.isEmpty() && (stack.is(Blocks.SAND.asItem()) || stack.is(Blocks.RED_SAND.asItem()) || stack.is(Blocks.SOUL_SAND.asItem()) || stack.is(BotaniaItems.manaPowder));
            }
        };
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.time = 0;
            this.timeFraction = 0.0f;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.putInt(TAG_TIME, this.time);
        tag.putFloat(TAG_TIME_FRACTION, this.timeFraction);
        tag.putBoolean(TAG_FLIP, this.flip);
        tag.putInt(TAG_FLIP_TICKS, this.flipTicks);
        tag.putBoolean(TAG_MOVE, this.move);
        tag.putBoolean(TAG_LOCK, this.lock);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.time = tag.getInt(TAG_TIME);
        this.timeFraction = tag.getFloat(TAG_TIME_FRACTION);
        this.flip = tag.getBoolean(TAG_FLIP);
        this.flipTicks = tag.getInt(TAG_FLIP_TICKS);
        this.move = tag.getBoolean(TAG_MOVE);
        this.lock = tag.getBoolean(TAG_LOCK);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        boolean bl = this.lock = !this.lock;
        if (!this.getLevel().isClientSide) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public static class WandHud
    implements WandHUD {
        private final HoveringHourglassBlockEntity hourglass;

        public WandHud(HoveringHourglassBlockEntity hourglass) {
            this.hourglass = hourglass;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack stack = this.hourglass.getItemHandler().getItem(0);
            if (!stack.isEmpty()) {
                String status;
                String second;
                String first;
                int x = mc.getWindow().getGuiScaledWidth() / 2 + 8;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 10;
                if (this.hourglass.isDust()) {
                    first = Integer.toString(this.hourglass.time);
                    second = Integer.toString(this.hourglass.getTotalTime());
                } else {
                    first = StringUtil.formatTickDuration((int)this.hourglass.time);
                    second = StringUtil.formatTickDuration((int)this.hourglass.getTotalTime());
                }
                String timer = String.format("%s / %s", first, second);
                String string = status = this.hourglass.lock ? "locked" : "";
                if (!this.hourglass.move) {
                    String string2 = status = status.isEmpty() ? "stopped" : "lockedStopped";
                }
                if (!status.isEmpty()) {
                    status = I18n.get((String)("botaniamisc." + status), (Object[])new Object[0]);
                }
                int textWidth = Math.max(mc.font.width(timer), mc.font.width(status));
                RenderHelper.renderHUDBox(gui, x, y, x + textWidth + 24, y + 22);
                gui.renderFakeItem(stack, x + 2, y + 3);
                gui.renderItemDecorations(mc.font, stack, x + 2, y + 3);
                gui.drawString(mc.font, timer, x + 22, y + 2, this.hourglass.getColor());
                if (!status.isEmpty()) {
                    gui.drawString(mc.font, status, x + 22, y + 12, this.hourglass.getColor());
                }
            }
        }
    }
}

