/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class VanillaCorporeaNode
extends AbstractCorporeaNode {
    protected final Container inv;

    public VanillaCorporeaNode(Level world, BlockPos pos, Container inv, CorporeaSpark spark) {
        super(world, pos, spark);
        this.inv = inv;
    }

    @Override
    public List<ItemStack> countItems(CorporeaRequest request) {
        return this.iterateOverSlots(request, false);
    }

    @Override
    public List<ItemStack> extractItems(CorporeaRequest request) {
        return this.iterateOverSlots(request, true);
    }

    protected List<ItemStack> iterateOverSlots(CorporeaRequest request, boolean doit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = this.inv.getContainerSize() - 1; i >= 0; --i) {
            ItemStack copy;
            ItemStack stackAt = this.inv.getItem(i);
            if (!request.getMatcher().test(stackAt)) continue;
            request.trackFound(stackAt.getCount());
            int rem = Math.min(stackAt.getCount(), request.getStillNeeded() == -1 ? stackAt.getCount() : request.getStillNeeded());
            if (rem <= 0) continue;
            request.trackSatisfied(rem);
            if (doit) {
                copy = stackAt.copyWithCount(rem);
                if (this.getSpark().isCreative()) {
                    builder.add((Object)copy);
                } else {
                    builder.addAll(VanillaCorporeaNode.breakDownBigStack(this.inv.removeItem(i, rem)));
                    this.inv.setChanged();
                }
                this.getSpark().onItemExtracted(copy);
                request.trackExtracted(rem);
                continue;
            }
            copy = stackAt.copyWithCount(rem);
            builder.add((Object)copy);
        }
        return builder.build();
    }
}

