/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolMinecartEntity
extends AbstractMinecart {
    private static final int TRANSFER_RATE = 10000;
    private static final String TAG_MANA = "mana";
    private static final EntityDataAccessor<Integer> MANA = SynchedEntityData.defineId(ManaPoolMinecartEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ManaPoolMinecartEntity(EntityType<ManaPoolMinecartEntity> type, Level world) {
        super(type, world);
    }

    public ManaPoolMinecartEntity(Level world, double x, double y, double z) {
        super(BotaniaEntities.POOL_MINECART, world, x, y, z);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(MANA, (Object)0);
    }

    @NotNull
    public BlockState getDisplayBlockState() {
        return BotaniaBlocks.manaPool.defaultBlockState();
    }

    @NotNull
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return false;
    }

    protected void applyNaturalSlowdown() {
        float f = 0.98f;
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.0, (double)f));
    }

    @NotNull
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)BotaniaItems.poolMinecart);
    }

    public int getDefaultDisplayOffset() {
        return 8;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            double particleChance = 1.0 - (double)this.getMana() / 1000000.0 * 0.1;
            int color = 50943;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            double x = Mth.floor((double)this.getX());
            double y = Mth.floor((double)this.getY());
            double z = Mth.floor((double)this.getZ());
            if (Math.random() > particleChance) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, red, green, blue, 2.0f);
                this.level().addParticle((ParticleOptions)data, x + 0.3 + Math.random() * 0.5, y + 0.85 + Math.random() * 0.25, z + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
            }
        }
    }

    public void moveAlongTrack(BlockPos pos, BlockState state) {
        super.moveAlongTrack(pos, state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos pumpPos = pos.relative(dir);
            BlockState pumpState = this.level().getBlockState(pumpPos);
            if (!pumpState.is(BotaniaBlocks.pump)) continue;
            ManaPumpBlockEntity pump = (ManaPumpBlockEntity)this.level().getBlockEntity(pumpPos);
            BlockPos poolPos = pumpPos.relative(dir);
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.level(), poolPos, dir.getOpposite());
            if (!(receiver instanceof ManaPool)) continue;
            ManaPool pool = (ManaPool)receiver;
            Direction pumpDir = (Direction)pumpState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            boolean did = false;
            boolean can = false;
            if (pumpDir == dir) {
                int poolMana;
                int transfer;
                int actualTransfer;
                can = true;
                if (!pump.hasRedstone && (actualTransfer = Math.min(1000000 - (cartMana = this.getMana()), transfer = Math.min(10000, poolMana = pool.getCurrentMana()))) > 0) {
                    pool.receiveMana(-transfer);
                    this.setMana(cartMana + actualTransfer);
                    did = true;
                }
            } else if (pumpDir == dir.getOpposite()) {
                int transfer;
                can = true;
                if (!pump.hasRedstone && !pool.isFull() && (transfer = Math.min(10000, cartMana = this.getMana())) > 0) {
                    pool.receiveMana(transfer);
                    this.setMana(cartMana - transfer);
                    did = true;
                }
            }
            if (did) {
                pump.hasCart = true;
                pump.setActive(true);
            }
            if (!can) continue;
            pump.hasCartOnTop = true;
            pump.comparator = (int)((double)this.getMana() / 1000000.0 * 15.0);
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putInt(TAG_MANA, this.getMana());
    }

    protected void readAdditionalSaveData(CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.setMana(cmp.getInt(TAG_MANA));
    }

    public Item getDropItem() {
        return BotaniaItems.poolMinecart;
    }

    public int getComparatorLevel() {
        return ManaPoolBlockEntity.calculateComparatorLevel(this.getMana(), 1000000);
    }

    public int getMana() {
        return (Integer)this.entityData.get(MANA);
    }

    public void setMana(int mana) {
        this.entityData.set(MANA, (Object)mana);
    }
}

