/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.BotaniaItems;

public class PhantomInkRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<PhantomInkRecipe> SERIALIZER = new NoOpRecipeSerializer<PhantomInkRecipe>(PhantomInkRecipe::new);

    public PhantomInkRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer var1, @NotNull Level var2) {
        boolean foundInk = false;
        boolean foundItem = false;
        for (int i = 0; i < var1.getContainerSize(); ++i) {
            ItemStack stack = var1.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(BotaniaItems.phantomInk) && !foundInk) {
                foundInk = true;
                continue;
            }
            if (!foundItem) {
                if (stack.getItem() instanceof PhantomInkable && !stack.getItem().hasCraftingRemainingItem()) {
                    foundItem = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundInk && foundItem;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack item = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof PhantomInkable) || !item.isEmpty()) continue;
            item = stack;
        }
        PhantomInkable inkable = (PhantomInkable)item.getItem();
        ItemStack copy = item.copy();
        inkable.setPhantomInk(copy, !inkable.hasPhantomInk(item));
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

