/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaBlasterTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("fire_mana_blaster");
    public static final ManaBlasterTrigger INSTANCE = new ManaBlasterTrigger();

    private ManaBlasterTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, ContextAwarePredicate playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, ItemPredicate.fromJson((JsonElement)json.get("item")), EntityPredicate.fromJson((JsonElement)json.get("user")));
    }

    public void trigger(ServerPlayer player, ItemStack stack) {
        this.trigger(player, instance -> instance.test(stack, player));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final EntityPredicate user;

        public Instance(ContextAwarePredicate entityPred, ItemPredicate count, EntityPredicate user) {
            super(ID, entityPred);
            this.item = count;
            this.user = user;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ItemStack stack, ServerPlayer entity) {
            return this.item.matches(stack) && this.user.matches(entity, (Entity)entity);
        }

        public JsonObject serializeToJson(SerializationContext context) {
            JsonObject json = super.serializeToJson(context);
            if (this.item != ItemPredicate.ANY) {
                json.add("item", this.item.serializeToJson());
            }
            if (this.user != EntityPredicate.ANY) {
                json.add("user", this.user.serializeToJson());
            }
            return json;
        }

        public ItemPredicate getItem() {
            return this.item;
        }

        public EntityPredicate getUser() {
            return this.user;
        }
    }
}

