/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class EndoflameBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final int FUEL_CAP = 32000;
    private static final int RANGE = 3;
    private static final int START_BURN_EVENT = 0;
    private int burnTime = 0;

    public EndoflameBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.ENDOFLAME, pos, state);
    }

    @Override
    public void tickFlower() {
        boolean wasBurning;
        super.tickFlower();
        boolean bl = wasBurning = this.burnTime > 0;
        if (wasBurning) {
            --this.burnTime;
        }
        if (this.getLevel().isClientSide) {
            if (this.burnTime > 0 && this.getLevel().random.nextInt(10) == 0) {
                this.emitParticle((ParticleOptions)ParticleTypes.FLAME, 0.4 + Math.random() * 0.2, 0.7, 0.4 + Math.random() * 0.2, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.burnTime > 0 && this.ticksExisted % 2 == 0) {
            this.addMana(3);
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana()) {
                for (ItemEntity item : this.getLevel().getEntitiesOfClass(ItemEntity.class, new AABB(this.getEffectivePos().offset(-3, -3, -3), this.getEffectivePos().offset(4, 4, 4)))) {
                    int burnTime;
                    ItemStack stack;
                    if (!DelayHelper.canInteractWith(this, item) || (stack = item.getItem()).getItem().hasCraftingRemainingItem() || (burnTime = this.getBurnTime(stack)) <= 0 || stack.getCount() <= 0) continue;
                    this.burnTime = Math.min(32000, burnTime) / 2;
                    EntityHelper.shrinkItem(item);
                    this.getLevel().playSound(null, this.getEffectivePos(), BotaniaSounds.endoflame, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, item.getId());
                    this.getLevel().gameEvent(null, GameEvent.BLOCK_ACTIVATE, this.getBlockPos());
                    this.sync();
                    return;
                }
            }
            if (wasBurning) {
                this.getLevel().gameEvent(null, GameEvent.BLOCK_DEACTIVATE, this.getBlockPos());
            }
        }
    }

    public boolean triggerEvent(int event, int param) {
        if (event == 0) {
            Entity e = this.getLevel().getEntity(param);
            if (e != null) {
                e.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, e.getX(), e.getY() + 0.1, e.getZ(), 0.0, 0.0, 0.0);
                e.level().addParticle((ParticleOptions)ParticleTypes.FLAME, e.getX(), e.getY(), e.getZ(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.triggerEvent(event, param);
    }

    @Override
    public int getMaxMana() {
        return 300;
    }

    @Override
    public int getColor() {
        return 7884800;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 3);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.putInt(TAG_BURN_TIME, this.burnTime);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.getInt(TAG_BURN_TIME);
    }

    private int getBurnTime(ItemStack stack) {
        if (stack.isEmpty() || Block.byItem((Item)stack.getItem()) instanceof ManaSpreaderBlock) {
            return 0;
        }
        return XplatAbstractions.INSTANCE.getSmeltingBurnTime(stack);
    }
}

