/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.SpecialFlowerBlockEntityRenderer;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LuminizerBlockEntityRenderer
implements BlockEntityRenderer<LuminizerBlockEntity> {
    private final TextureAtlasSprite luminizerWorldSprite;
    private final TextureAtlasSprite detectorLuminizerWorldSprite;
    private final TextureAtlasSprite forkLuminizerWorldSprite;
    private final TextureAtlasSprite toggleLuminizerWorldSprite;

    public LuminizerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        Function atlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        this.luminizerWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(ResourceLocationHelper.prefix("block/light_relay")));
        this.detectorLuminizerWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(ResourceLocationHelper.prefix("block/detector_light_relay")));
        this.forkLuminizerWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(ResourceLocationHelper.prefix("block/fork_light_relay")));
        this.toggleLuminizerWorldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(ResourceLocationHelper.prefix("block/toggle_light_relay")));
    }

    public void render(@NotNull LuminizerBlockEntity tile, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        LivingEntity view;
        BlockState state = tile.getBlockState();
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.getCameraEntity();
        if (entity instanceof LivingEntity && ManaseerMonocleItem.hasMonocle(view = (LivingEntity)entity) && SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.getBlockPos())) {
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, new RadiusDescriptor.Circle(tile.getBlockPos(), 20.0));
        }
        TextureAtlasSprite sprite = switch (((LuminizerBlock)state.getBlock()).variant) {
            default -> throw new IncompatibleClassChangeError();
            case LuminizerVariant.DEFAULT -> this.luminizerWorldSprite;
            case LuminizerVariant.DETECTOR -> this.detectorLuminizerWorldSprite;
            case LuminizerVariant.FORK -> this.forkLuminizerWorldSprite;
            case LuminizerVariant.TOGGLE -> this.toggleLuminizerWorldSprite;
        };
        ms.pushPose();
        ms.translate(0.5, 0.3, 0.5);
        double time = (float)ClientTickHandler.ticksInGame + pticks;
        float scale = 0.75f;
        ms.scale(scale, scale, scale);
        ms.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
        ms.mulPose(VecHelper.rotateY(180.0f));
        float off = 0.25f;
        ms.translate(0.0f, off, 0.0f);
        ms.mulPose(VecHelper.rotateZ((float)time));
        ms.translate(0.0f, -off, 0.0f);
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.LIGHT_RELAY);
        this.renderIcon(ms, buffer, sprite);
        ms.popPose();
    }

    private void renderIcon(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon) {
        float size = icon.getU1() - icon.getU0();
        float pad = size / 8.0f;
        float f = icon.getU0() + pad;
        float f1 = icon.getU1() - pad;
        float f2 = icon.getV0() + pad;
        float f3 = icon.getV1() - pad;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        Matrix4f mat = ms.last().pose();
        buffer.vertex(mat, 0.0f - f5, 0.0f - f6, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(f, f3).endVertex();
        buffer.vertex(mat, f4 - f5, 0.0f - f6, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(f1, f3).endVertex();
        buffer.vertex(mat, f4 - f5, f4 - f6, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(f1, f2).endVertex();
        buffer.vertex(mat, 0.0f - f5, f4 - f6, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(f, f2).endVertex();
    }
}

