/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class BrewProvider
extends BotaniaRecipeProvider {
    public BrewProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Botania Brew recipes";
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("speed"), BotaniaBrews.speed, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("strength"), BotaniaBrews.strength, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("haste"), BotaniaBrews.haste, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_NUGGET})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("healing"), BotaniaBrews.healing, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLISTERING_MELON_SLICE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("jump_boost"), BotaniaBrews.jumpBoost, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("regeneration"), BotaniaBrews.regen, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("weak_regeneration"), BotaniaBrews.regenWeak, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("resistance"), BotaniaBrews.resistance, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("fire_resistance"), BotaniaBrews.fireResistance, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_CREAM}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.NETHERRACK})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("water_breathing"), BotaniaBrews.waterBreathing, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_CRYSTALS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("invisibility"), BotaniaBrews.invisibility, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SNOWBALL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("night_vision"), BotaniaBrews.nightVision, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("absorption"), BotaniaBrews.absorption, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("overload"), BotaniaBrews.overload, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaSteel}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("soul_cross"), BotaniaBrews.soulCross, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SOUL_SAND}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("feather_feet"), BotaniaBrews.featherfeet, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}), Ingredient.of((TagKey)ItemTags.WOOL)));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("emptiness"), BotaniaBrews.emptiness, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("bloodthirst"), BotaniaBrews.bloodthirst, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FERMENTED_SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CHARGE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("allure"), BotaniaBrews.allure, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT})));
        consumer.accept(new FinishedRecipe(BrewProvider.idFor("clear"), BotaniaBrews.clear, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ}), Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE})));
    }

    private static ResourceLocation idFor(String s) {
        return ResourceLocationHelper.prefix("brew/" + s);
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private final ResourceLocation id;
        private final Brew brew;
        private final Ingredient[] inputs;

        private FinishedRecipe(ResourceLocation id, Brew brew, Ingredient ... inputs) {
            this.id = id;
            this.brew = brew;
            this.inputs = inputs;
        }

        public void serializeRecipeData(JsonObject json) {
            json.addProperty("brew", BotaniaAPI.instance().getBrewRegistry().getKey((Object)this.brew).toString());
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                ingredients.add(ingr.toJson());
            }
            json.add("ingredients", (JsonElement)ingredients);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.BREW_SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

