/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.data.util.SimpleModelSupplierWithOverrides;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ItemModelProvider
implements DataProvider {
    private static final TextureSlot LAYER1 = TextureSlotAccessor.make("layer1");
    private static final TextureSlot LAYER2 = TextureSlotAccessor.make("layer2");
    private static final TextureSlot LAYER3 = TextureSlotAccessor.make("layer3");
    private static final ModelTemplate GENERATED_1 = new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0, LAYER1});
    private static final ModelTemplate GENERATED_2 = new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0, LAYER1, LAYER2});
    private static final ModelTemplate HANDHELD_1 = new ModelTemplate(Optional.of(new ResourceLocation("item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0, LAYER1});
    private static final ModelTemplate HANDHELD_3 = new ModelTemplate(Optional.of(new ResourceLocation("item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0, LAYER1, LAYER2, LAYER3});
    private static final ModelTemplate WALL_INVENTORY = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.WALL});
    private static final ModelTemplate WALL_INVENTORY_CHECKERED = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory_checkered")), Optional.empty(), new TextureSlot[]{TextureSlot.NORTH, TextureSlot.SIDE});
    private static final TextureSlot OUTSIDE = TextureSlotAccessor.make("outside");
    private static final TextureSlot CORE = TextureSlotAccessor.make("core");
    private static final ModelTemplate SPREADER = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_item")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.BACK, TextureSlot.INSIDE, OUTSIDE, CORE});
    private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(new ResourceLocation("item/generated"), TextureSlot.LAYER0);
    private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(new ResourceLocation("item/generated"), TextureSlot.LAYER0, LAYER1);
    private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(new ResourceLocation("item/handheld"), TextureSlot.LAYER0);
    private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(new ResourceLocation("item/handheld"), TextureSlot.LAYER0, LAYER1, LAYER2);
    private final PackOutput packOutput;
    private static final String BUILTIN_ENTITY_DISPLAY_STR = "{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}";
    private static final JsonElement BUILTIN_ENTITY_DISPLAY = (JsonElement)new Gson().fromJson("{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}", JsonElement.class);

    public ItemModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Set<Item> items = BuiltInRegistries.ITEM.stream().filter(i -> "botania".equals(BuiltInRegistries.ITEM.getKey(i).getNamespace())).collect(Collectors.toSet());
        HashMap map = new HashMap();
        this.registerItemBlocks(ItemModelProvider.takeAll(items, i -> i instanceof BlockItem).stream().map(i -> (BlockItem)i).collect(Collectors.toSet()), map::put);
        ItemModelProvider.registerItemOverrides(items, map::put);
        ItemModelProvider.registerItems(items, map::put);
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : map.entrySet()) {
            ResourceLocation id = (ResourceLocation)e.getKey();
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)modelPathProvider.json(id)));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private static void registerItems(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(BotaniaItems.manaGun);
        ItemModelProvider.takeAll(items, i -> i instanceof LensItem).forEach(i -> {
            ResourceLocation lens = i == BotaniaItems.lensTime || i == BotaniaItems.lensWarp || i == BotaniaItems.lensFire || i == BotaniaItems.lensTripwire ? ResourceLocationHelper.prefix("item/lens_small") : ResourceLocationHelper.prefix("item/lens");
            GENERATED_1.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((ResourceLocation)lens).put(LAYER1, TextureMapping.getItemTexture((Item)i)), consumer);
        });
        GENERATED_1.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.bloodPendant), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)BotaniaItems.bloodPendant)).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.bloodPendant, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.bloodPendant);
        HANDHELD_1.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.enderDagger), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)BotaniaItems.enderDagger)).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.enderDagger, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.enderDagger);
        GENERATED_1.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.incenseStick), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)BotaniaItems.incenseStick)).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.incenseStick, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.incenseStick);
        GENERATED_1.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.manaMirror), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)BotaniaItems.manaMirror)).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.manaMirror, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.manaMirror);
        GENERATED_1.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.manaTablet), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)BotaniaItems.manaTablet)).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.manaTablet, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.manaTablet);
        GENERATED_2.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.thirdEye), new TextureMapping().put(TextureSlot.LAYER0, TextureMapping.getItemTexture((Item)BotaniaItems.thirdEye, (String)"_0")).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.thirdEye, (String)"_1")).put(LAYER2, TextureMapping.getItemTexture((Item)BotaniaItems.thirdEye, (String)"_2")), consumer);
        items.remove(BotaniaItems.thirdEye);
        ItemModelProvider.takeAll(items, BotaniaItems.cobbleRod, BotaniaItems.dirtRod, BotaniaItems.diviningRod, BotaniaItems.elementiumAxe, BotaniaItems.elementiumPick, BotaniaItems.elementiumShovel, BotaniaItems.elementiumHoe, BotaniaItems.elementiumSword, BotaniaItems.exchangeRod, BotaniaItems.fireRod, BotaniaItems.glassPick, BotaniaItems.gravityRod, BotaniaItems.manasteelAxe, BotaniaItems.manasteelPick, BotaniaItems.manasteelShears, BotaniaItems.manasteelShovel, BotaniaItems.manasteelHoe, BotaniaItems.missileRod, BotaniaItems.obedienceStick, BotaniaItems.rainbowRod, BotaniaItems.smeltRod, BotaniaItems.starSword, BotaniaItems.terraSword, BotaniaItems.terraformRod, BotaniaItems.thunderSword, BotaniaItems.waterRod, BotaniaItems.kingKey, BotaniaItems.skyDirtRod).forEach(i -> ModelTemplates.FLAT_HANDHELD_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((Item)i), consumer));
        ItemModelProvider.takeAll(items, i -> true).forEach(i -> ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((Item)i), consumer));
    }

    private static void singleGeneratedOverride(Item item, ResourceLocation overrideModel, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ModelTemplates.FLAT_ITEM.create(overrideModel, TextureMapping.layer0((ResourceLocation)overrideModel), consumer);
        GENERATED_OVERRIDES.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Item)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleGeneratedSuffixOverride(Item item, String suffix, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleGeneratedOverride(item, ModelLocationUtils.getModelLocation((Item)item, (String)suffix), predicate, value, consumer);
    }

    private static void singleHandheldOverride(Item item, ResourceLocation overrideModel, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ModelTemplates.FLAT_HANDHELD_ITEM.create(overrideModel, TextureMapping.layer0((ResourceLocation)overrideModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Item)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleHandheldSuffixOverride(Item item, String suffix, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleHandheldOverride(item, ModelLocationUtils.getModelLocation((Item)item, (String)suffix), predicate, value, consumer);
    }

    private static void registerItemOverrides(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(BotaniaItems.livingwoodBow);
        items.remove(BotaniaItems.crystalBow);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.baubleBox, "_open", ResourceLocationHelper.prefix("open"), 1.0, consumer);
        items.remove(BotaniaItems.baubleBox);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.blackHoleTalisman, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.blackHoleTalisman);
        ItemModelProvider.registerBrewContainerOverrides(BotaniaItems.brewFlask, BotaniaItems.flask, consumer);
        items.remove(BotaniaItems.brewFlask);
        ItemModelProvider.registerBrewContainerOverrides(BotaniaItems.brewVial, BotaniaItems.vial, consumer);
        items.remove(BotaniaItems.brewVial);
        ItemModelProvider.singleHandheldOverride(BotaniaItems.elementiumShears, ResourceLocationHelper.prefix("item/dammitreddit"), ResourceLocationHelper.prefix("reddit"), 1.0, consumer);
        items.remove(BotaniaItems.elementiumShears);
        ResourceLocation vuvuzela = ResourceLocationHelper.prefix("item/vuvuzela");
        ModelTemplates.FLAT_HANDHELD_ITEM.create(vuvuzela, TextureMapping.layer0((ResourceLocation)vuvuzela), consumer);
        for (Item i : new Item[]{BotaniaItems.grassHorn, BotaniaItems.leavesHorn, BotaniaItems.snowHorn}) {
            GENERATED_OVERRIDES.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((Item)i), new OverrideHolder().add(vuvuzela, Pair.of((Object)ResourceLocationHelper.prefix("vuvuzela"), (Object)1.0)), consumer);
        }
        items.remove(BotaniaItems.grassHorn);
        items.remove(BotaniaItems.leavesHorn);
        items.remove(BotaniaItems.snowHorn);
        ItemModelProvider.singleGeneratedOverride(BotaniaItems.infiniteFruit, ResourceLocationHelper.prefix("item/dasboot"), ResourceLocationHelper.prefix("boot"), 1.0, consumer);
        items.remove(BotaniaItems.infiniteFruit);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.lexicon, "_elven", ResourceLocationHelper.prefix("elven"), 1.0, consumer);
        items.remove(BotaniaItems.lexicon);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.magnetRing, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.magnetRing);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.magnetRingGreater, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.magnetRingGreater);
        OverrideHolder bottleOverrides = new OverrideHolder();
        for (int i = 1; i < 6; ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.getModelLocation((Item)BotaniaItems.manaBottle, (String)("_" + i));
            ModelTemplates.FLAT_ITEM.create(overrideModel, TextureMapping.layer0((ResourceLocation)overrideModel), consumer);
            bottleOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)((double)i / 5.0)));
        }
        GENERATED_OVERRIDES.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.manaBottle), TextureMapping.layer0((Item)BotaniaItems.manaBottle), bottleOverrides, consumer);
        items.remove(BotaniaItems.manaBottle);
        ItemModelProvider.singleGeneratedOverride(BotaniaItems.manaCookie, ResourceLocationHelper.prefix("item/totalbiscuit"), ResourceLocationHelper.prefix("totalbiscuit"), 1.0, consumer);
        items.remove(BotaniaItems.manaCookie);
        ItemModelProvider.singleHandheldOverride(BotaniaItems.manasteelSword, ResourceLocationHelper.prefix("item/elucidator"), ResourceLocationHelper.prefix("elucidator"), 1.0, consumer);
        items.remove(BotaniaItems.manasteelSword);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveHelm, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveHelm);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveChest, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveChest);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveLegs, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveLegs);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveBoots, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveBoots);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.slimeBottle, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.slimeBottle);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.spawnerMover, "_full", ResourceLocationHelper.prefix("full"), 1.0, consumer);
        items.remove(BotaniaItems.spawnerMover);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.temperanceStone, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.temperanceStone);
        ItemModelProvider.singleHandheldSuffixOverride(BotaniaItems.terraAxe, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.terraAxe);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.autocraftingHalo, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.autocraftingHalo);
        ResourceLocation enabledModel = ModelLocationUtils.getModelLocation((Item)BotaniaItems.terraPick, (String)"_active");
        ModelTemplates.FLAT_HANDHELD_ITEM.create(enabledModel, TextureMapping.layer0((ResourceLocation)enabledModel), consumer);
        ResourceLocation tippedModel = ModelLocationUtils.getModelLocation((Item)BotaniaItems.terraPick, (String)"_tipped");
        ModelTemplates.FLAT_HANDHELD_ITEM.create(tippedModel, TextureMapping.layer0((ResourceLocation)tippedModel), consumer);
        ResourceLocation tippedEnabledModel = ModelLocationUtils.getModelLocation((Item)BotaniaItems.terraPick, (String)"_tipped_active");
        ModelTemplates.FLAT_HANDHELD_ITEM.create(tippedEnabledModel, TextureMapping.layer0((ResourceLocation)tippedEnabledModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.terraPick), TextureMapping.layer0((Item)BotaniaItems.terraPick), new OverrideHolder().add(enabledModel, Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)).add(tippedModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0)).add(tippedEnabledModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0), Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.terraPick);
        ItemModelProvider.singleHandheldSuffixOverride(BotaniaItems.tornadoRod, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.tornadoRod);
        TextureMapping twigWandTextures = TextureMapping.layer0((Item)BotaniaItems.twigWand).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.twigWand, (String)"_top")).put(LAYER2, TextureMapping.getItemTexture((Item)BotaniaItems.twigWand, (String)"_bottom"));
        ResourceLocation twigWandBind = ModelLocationUtils.getModelLocation((Item)BotaniaItems.twigWand, (String)"_bind");
        HANDHELD_3.create(twigWandBind, twigWandTextures.copyAndUpdate(LAYER3, TextureMapping.getItemTexture((Item)BotaniaItems.twigWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.twigWand), twigWandTextures, new OverrideHolder().add(twigWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.twigWand);
        TextureMapping dreamwoodWandTextures = TextureMapping.layer0((Item)BotaniaItems.dreamwoodWand).put(LAYER1, TextureMapping.getItemTexture((Item)BotaniaItems.dreamwoodWand, (String)"_top")).put(LAYER2, TextureMapping.getItemTexture((Item)BotaniaItems.dreamwoodWand, (String)"_bottom"));
        ResourceLocation dreamwoodWandBind = ModelLocationUtils.getModelLocation((Item)BotaniaItems.dreamwoodWand, (String)"_bind");
        HANDHELD_3.create(dreamwoodWandBind, dreamwoodWandTextures.copyAndUpdate(LAYER3, TextureMapping.getItemTexture((Item)BotaniaItems.dreamwoodWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(ModelLocationUtils.getModelLocation((Item)BotaniaItems.dreamwoodWand), dreamwoodWandTextures, new OverrideHolder().add(dreamwoodWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.dreamwoodWand);
    }

    private static void registerBrewContainerOverrides(BaseBrewItem brewItem, Item emptyItem, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        OverrideHolder flaskOverrides = new OverrideHolder();
        for (int i = 1; i < brewItem.getSwigs(); ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.getModelLocation((Item)brewItem, (String)("_" + i));
            GENERATED_1.create(overrideModel, TextureMapping.layer0((Item)emptyItem).put(LAYER1, overrideModel), consumer);
            flaskOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)((double)i / (double)(brewItem.getSwigs() - 1))));
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.getModelLocation((Item)brewItem), TextureMapping.layer0((Item)emptyItem).put(LAYER1, TextureMapping.getItemTexture((Item)brewItem, (String)"_0")), flaskOverrides, consumer);
    }

    private void registerItemBlocks(Set<BlockItem> itemBlocks, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        itemBlocks.remove(BotaniaBlocks.corporeaCrystalCube.asItem());
        itemBlocks.removeIf(i -> {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)i.getBlock());
            return id.getNamespace().equals("botania") && i.getBlock() instanceof FloatingFlowerBlock;
        });
        GENERATED_1.create(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.animatedTorch.asItem()), TextureMapping.layer0((Block)Blocks.REDSTONE_TORCH).put(LAYER1, ResourceLocationHelper.prefix("block/animated_torch_glimmer")), consumer);
        itemBlocks.remove(BotaniaBlocks.animatedTorch.asItem());
        ModelTemplates.SKULL_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.gaiaHead.asItem()), new TextureMapping(), consumer);
        itemBlocks.remove(BotaniaBlocks.gaiaHead.asItem());
        ItemModelProvider.takeAll(itemBlocks, i -> i.getBlock() instanceof BotaniaDoubleFlowerBlock).forEach(i -> ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((ResourceLocation)TextureMapping.getBlockTexture((Block)i.getBlock(), (String)"_top")), consumer));
        ItemModelProvider.takeAll(itemBlocks, i -> i.getBlock() instanceof PetalBlock).forEach(i -> consumer.accept(ModelLocationUtils.getModelLocation((Item)i), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/petal_block"))));
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.livingwoodFramed.asItem(), BotaniaBlocks.dreamwoodFramed.asItem()).forEach(i -> {
            String name = i == BotaniaBlocks.livingwoodFramed.asItem() ? "livingwood" : "dreamwood";
            consumer.accept(ModelLocationUtils.getModelLocation((Item)i), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_" + name + "_horizontal_z")));
        });
        consumer.accept(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.livingwoodFramed.asItem()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_livingwood_horizontal_z")));
        consumer.accept(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.dreamwoodFramed.asItem()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_dreamwood_horizontal_z")));
        itemBlocks.remove(BotaniaBlocks.livingwoodFramed.asItem());
        itemBlocks.remove(BotaniaBlocks.dreamwoodFramed.asItem());
        ItemModelProvider.takeAll(itemBlocks, i -> i.getBlock() instanceof IronBarsBlock).forEach(i -> {
            String name = BuiltInRegistries.ITEM.getKey(i).getPath();
            String baseName = name.substring(0, name.length() - "_pane".length());
            ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((ResourceLocation)ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        Predicate<BlockItem> defaultGenerated = i -> {
            Block b = i.getBlock();
            return XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b) || b instanceof BotaniaMushroomBlock || b instanceof LuminizerBlock || b instanceof BotaniaFlowerBlock || b == BotaniaBlocks.ghostRail;
        };
        ItemModelProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((Block)i.getBlock()), consumer));
        ItemModelProvider.takeAll(itemBlocks, b -> b.getBlock() instanceof FlowerMotifBlock).forEach(i -> {
            String name = BuiltInRegistries.ITEM.getKey(i).getPath();
            ResourceLocation texName = ResourceLocationHelper.prefix("block/" + name.replace("_motif", ""));
            ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((ResourceLocation)texName), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.getBlock() instanceof ManaPoolBlock).forEach(i -> {
            ResourceLocation fullModel = ModelLocationUtils.getModelLocation((Block)i.getBlock(), (String)"_full");
            OverrideHolder overrides = new OverrideHolder().add(fullModel, Pair.of((Object)ResourceLocationHelper.prefix("full"), (Object)1.0));
            consumer.accept(ModelLocationUtils.getModelLocation((Item)i), (Supplier<JsonElement>)((Object)new SimpleModelSupplierWithOverrides(ModelLocationUtils.getModelLocation((Block)i.getBlock()), overrides)));
        });
        ItemModelProvider.takeAll(itemBlocks, (BlockItem[])Stream.of(BotaniaBlocks.livingwoodWall, BotaniaBlocks.livingwoodStrippedWall, BotaniaBlocks.dreamwoodWall, BotaniaBlocks.dreamwoodStrippedWall).map(b -> (BlockItem)b.asItem()).toArray(BlockItem[]::new)).forEach(i -> {
            String name = BuiltInRegistries.ITEM.getKey(i).getPath();
            String baseName = name.substring(0, name.length() - "_wall".length()) + "_log";
            ModelTemplates.WALL_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)i), new TextureMapping().put(TextureSlot.WALL, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.getBlock() instanceof WallBlock).forEach(i -> {
            String name = BuiltInRegistries.ITEM.getKey(i).getPath();
            String baseName = name.substring(0, name.length() - "_wall".length());
            ModelTemplates.WALL_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)i), new TextureMapping().put(TextureSlot.WALL, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.getBlock() instanceof ManaSpreaderBlock).forEach(i -> {
            String name = BuiltInRegistries.ITEM.getKey(i).getPath();
            Object outside = i.getBlock() == BotaniaBlocks.elvenSpreader ? "dreamwood_log_3" : (i.getBlock() == BotaniaBlocks.gaiaSpreader ? name + "_outside" : "livingwood_log");
            Object inside = i.getBlock() == BotaniaBlocks.elvenSpreader ? "stripped_dreamwood_log_3" : (i.getBlock() == BotaniaBlocks.gaiaSpreader ? name + "_inside" : "stripped_livingwood_log");
            SPREADER.create(ModelLocationUtils.getModelLocation((Item)i), new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)i.getBlock(), (String)"_side")).put(OUTSIDE, ResourceLocationHelper.prefix("block/" + (String)outside)).put(TextureSlot.BACK, TextureMapping.getBlockTexture((Block)i.getBlock(), (String)"_back")).put(TextureSlot.INSIDE, ResourceLocationHelper.prefix("block/" + (String)inside)).put(CORE, TextureMapping.getBlockTexture((Block)i.getBlock(), (String)"_core")), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.avatar.asItem(), BotaniaBlocks.bellows.asItem(), BotaniaBlocks.brewery.asItem(), BotaniaBlocks.corporeaIndex.asItem(), BotaniaBlocks.gaiaPylon.asItem(), BotaniaBlocks.hourglass.asItem(), BotaniaBlocks.manaPylon.asItem(), BotaniaBlocks.naturaPylon.asItem()).forEach(i -> this.builtinEntity((Item)i, consumer));
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.teruTeruBozu.asItem()).forEach(i -> this.builtinEntity((Item)i, consumer, 2.5));
        ItemModelProvider.takeAll(itemBlocks, i -> i instanceof MysticalPetalItem).forEach(i -> ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)i), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)i)), consumer));
        ModelTemplates.FENCE_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.dreamwoodFence.asItem()), TextureMapping.defaultTexture((Block)BotaniaBlocks.dreamwoodPlanks), consumer);
        itemBlocks.remove(BotaniaBlocks.dreamwoodFence.asItem());
        ModelTemplates.FENCE_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.livingwoodFence.asItem()), TextureMapping.defaultTexture((Block)BotaniaBlocks.livingwoodPlanks), consumer);
        itemBlocks.remove(BotaniaBlocks.livingwoodFence.asItem());
        consumer.accept(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.elfGlass.asItem()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/elf_glass_0")));
        itemBlocks.remove(BotaniaBlocks.elfGlass.asItem());
        WALL_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.biomeBrickPlainsWall.asItem()), new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickPlains, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickPlains, (String)"_top")).put(TextureSlot.WALL, TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickPlains)), consumer);
        itemBlocks.remove(BotaniaBlocks.biomeBrickPlainsWall.asItem());
        WALL_INVENTORY_CHECKERED.create(ModelLocationUtils.getModelLocation((Item)BotaniaBlocks.biomeBrickMesaWall.asItem()), new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMesa)).put(TextureSlot.NORTH, TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMesa, (String)"_mirrored")), consumer);
        itemBlocks.remove(BotaniaBlocks.biomeBrickMesaWall.asItem());
        itemBlocks.forEach(i -> consumer.accept(ModelLocationUtils.getModelLocation((Item)i), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.getModelLocation((Block)i.getBlock()))));
    }

    protected void builtinEntity(Item i, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        this.builtinEntity(i, consumer, 0.0);
    }

    protected void builtinEntity(Item i, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer, double handYOffset) {
        JsonElement display;
        if (handYOffset == 0.0) {
            display = BUILTIN_ENTITY_DISPLAY;
        } else {
            display = BUILTIN_ENTITY_DISPLAY.deepCopy();
            display.getAsJsonObject().getAsJsonObject("firstperson_righthand").getAsJsonArray("translation").set(1, (JsonElement)new JsonPrimitive((Number)handYOffset));
        }
        consumer.accept(ModelLocationUtils.getModelLocation((Item)i), () -> {
            JsonObject json = new JsonObject();
            json.addProperty("parent", "minecraft:builtin/entity");
            json.add("display", display);
            return json;
        });
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    @NotNull
    public String getName() {
        return "Botania item models";
    }
}

