/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public final class ToolCommons {
    private static boolean recCall = false;

    public static int damageItemIfPossible(ItemStack stack, int amount, LivingEntity entity, int manaPerDamage) {
        Player player;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else {
            return amount;
        }
        while (amount > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, manaPerDamage, true)) {
            --amount;
        }
        return amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBlocksInIteration(Player player, ItemStack stack, Level world, BlockPos centerPos, Vec3i startDelta, Vec3i endDelta, Predicate<BlockState> filter) {
        if (recCall) {
            return;
        }
        recCall = true;
        try {
            for (BlockPos iterPos : BlockPos.betweenClosed((BlockPos)centerPos.offset(startDelta), (BlockPos)centerPos.offset(endDelta))) {
                if (iterPos.equals((Object)centerPos)) continue;
                ToolCommons.removeBlockWithDrops(player, stack, world, iterPos, filter);
            }
        }
        finally {
            recCall = false;
        }
    }

    public static void removeBlockWithDrops(Player player, ItemStack stack, Level world, BlockPos pos, Predicate<BlockState> filter) {
        boolean unminable;
        if (!world.hasChunkAt(pos)) {
            return;
        }
        BlockState blockstate = world.getBlockState(pos);
        boolean bl = unminable = blockstate.getDestroyProgress(player, (BlockGetter)world, pos) == 0.0f;
        if (!world.isClientSide && !unminable && filter.test(blockstate) && !blockstate.isAir()) {
            ItemStack save = player.getMainHandItem();
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            ((ServerPlayer)player).connection.send((Packet)new ClientboundLevelEventPacket(2001, pos, Block.getId((BlockState)blockstate), false));
            ((ServerPlayer)player).gameMode.destroyBlock(pos);
            player.setItemInHand(InteractionHand.MAIN_HAND, save);
        }
    }

    public static int getToolPriority(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        Item item = stack.getItem();
        if (!(item instanceof DiggerItem)) {
            return 0;
        }
        DiggerItem tool = (DiggerItem)item;
        Tier material = tool.getTier();
        int materialLevel = 0;
        if (material == BotaniaAPI.instance().getManasteelItemTier()) {
            materialLevel = 10;
        }
        if (material == BotaniaAPI.instance().getElementiumItemTier()) {
            materialLevel = 11;
        }
        if (material == BotaniaAPI.instance().getTerrasteelItemTier()) {
            materialLevel = 20;
        }
        int modifier = 0;
        if (stack.is(BotaniaItems.terraPick)) {
            modifier = TerraShattererItem.getLevel(stack);
        }
        int efficiency = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.BLOCK_EFFICIENCY, (ItemStack)stack);
        return materialLevel * 100 + modifier * 10 + efficiency;
    }

    public static BlockHitResult raytraceFromEntity(Entity e, double distance, boolean fluids) {
        return (BlockHitResult)e.pick(distance, 1.0f, fluids);
    }
}

