/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class EntityHelper {
    public static void shrinkItem(ItemEntity entity) {
        entity.getItem().shrink(1);
        EntityHelper.syncItem(entity);
    }

    public static void syncItem(ItemEntity entity) {
        ItemStack save = entity.getItem();
        entity.setItem(ItemStack.EMPTY);
        entity.setItem(save);
    }

    public static void addStaticEffect(LivingEntity living, MobEffect mobEffect, int amplifier) {
        MobEffectInstance effect = living.getEffect(mobEffect);
        if (effect == null || effect.getAmplifier() < amplifier || effect.getAmplifier() == amplifier && !effect.isInfiniteDuration()) {
            living.addEffect(new MobEffectInstance(mobEffect, -1, amplifier, false, true, true));
        }
    }

    public static void convertStaticEffectToFinite(LivingEntity living, MobEffect mobEffect, int expectedAmplifier, int duration) {
        MobEffectInstance effect = living.getEffect(mobEffect);
        if (effect != null && effect.getAmplifier() == expectedAmplifier && effect.isInfiniteDuration()) {
            living.removeEffect(mobEffect);
            living.addEffect(new MobEffectInstance(mobEffect, duration, expectedAmplifier, false, true, true));
        }
    }

    public static void removeStaticEffect(LivingEntity living, MobEffect mobEffect, int expectedAmplifier) {
        MobEffectInstance effect = living.getEffect(mobEffect);
        if (effect != null && effect.getAmplifier() == expectedAmplifier && effect.isInfiniteDuration()) {
            living.removeEffect(mobEffect);
        }
    }
}

