/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;

public class BreweryBlockEntity
extends SimpleInventoryBlockEntity
implements ManaReceiver {
    private static final String TAG_MANA = "mana";
    private static final int CRAFT_EFFECT_EVENT = 0;
    public BotanicalBreweryRecipe recipe;
    private int mana = 0;
    private int manaLastTick = 0;
    public int signal = 0;

    public BreweryBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.BREWERY, pos, state);
    }

    public boolean addItem(@Nullable Player player, ItemStack stack, @Nullable InteractionHand hand) {
        BrewItem brew;
        Item item;
        if (this.recipe != null || stack.isEmpty() || (item = stack.getItem()) instanceof BrewItem && (brew = (BrewItem)item).getBrew(stack) != null && brew.getBrew(stack) != BotaniaBrews.fallbackBrew || this.getItemHandler().getItem(0).isEmpty() != stack.getItem() instanceof BrewContainer) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (!this.getItemHandler().getItem(i).isEmpty()) continue;
            did = true;
            ItemStack stackToAdd = stack.copyWithCount(1);
            this.getItemHandler().setItem(i, stackToAdd);
            if (player != null && player.getAbilities().instabuild) break;
            stack.shrink(1);
            if (!stack.isEmpty() || player == null) break;
            player.setItemInHand(hand, ItemStack.EMPTY);
            break;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.findRecipe();
        }
        return true;
    }

    private void findRecipe() {
        Optional maybeRecipe = this.level.getRecipeManager().getRecipeFor(BotaniaRecipeTypes.BREW_TYPE, this.getItemHandler(), this.level);
        maybeRecipe.ifPresent(recipeBrew -> {
            this.recipe = recipeBrew;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)BotaniaBlocks.brewery.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
        });
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, BreweryBlockEntity self) {
        if (self.mana > 0 && self.recipe == null) {
            self.findRecipe();
            if (self.recipe == null) {
                self.mana = 0;
            }
        }
        self.receiveMana(0);
        if (!level.isClientSide && self.recipe == null) {
            List items = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ(), (double)(worldPosition.getX() + 1), (double)(worldPosition.getY() + 1), (double)(worldPosition.getZ() + 1)));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.isAlive() || item.getItem().isEmpty() || !self.addItem(null, stack = item.getItem(), null)) continue;
                EntityHelper.syncItem(item);
            }
        }
        if (self.recipe != null) {
            if (!self.recipe.matches(self.getItemHandler(), level)) {
                self.recipe = null;
                level.setBlockAndUpdate(worldPosition, BotaniaBlocks.brewery.defaultBlockState());
            }
            if (self.recipe != null) {
                if (self.mana != self.manaLastTick) {
                    int color = self.recipe.getBrew().getColor(self.getItemHandler().getItem(0));
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data1 = WispParticleData.wisp(0.1f + (float)Math.random() * 0.05f, r, g, b);
                        level.addParticle((ParticleOptions)data1, (double)worldPosition.getX() + 0.7 - Math.random() * 0.4, (double)worldPosition.getY() + 0.9 - Math.random() * 0.2, (double)worldPosition.getZ() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        for (int j = 0; j < 2; ++j) {
                            WispParticleData data = WispParticleData.wisp(0.1f + (float)Math.random() * 0.2f, 0.2f, 0.2f, 0.2f);
                            level.addParticle((ParticleOptions)data, (double)worldPosition.getX() + 0.7 - Math.random() * 0.4, (double)worldPosition.getY() + 0.9 - Math.random() * 0.2, (double)worldPosition.getZ() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        }
                    }
                }
                if (self.mana >= self.getManaCost() && !level.isClientSide) {
                    int mana = self.getManaCost();
                    self.receiveMana(-mana);
                    ItemStack output = self.recipe.getOutput(self.getItemHandler().getItem(0));
                    ItemEntity outputItem = new ItemEntity(level, (double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 1.5, (double)worldPosition.getZ() + 0.5, output);
                    level.addFreshEntity((Entity)outputItem);
                    level.blockEvent(worldPosition, BotaniaBlocks.brewery, 0, self.recipe.getBrew().getColor(output));
                    for (int i = 0; i < self.inventorySize(); ++i) {
                        self.getItemHandler().setItem(i, ItemStack.EMPTY);
                    }
                }
            }
        }
        int newSignal = 0;
        if (self.recipe != null) {
            ++newSignal;
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.updateNeighbourForOutputSignal(worldPosition, state.getBlock());
        }
        self.manaLastTick = self.mana;
    }

    public boolean triggerEvent(int event, int param) {
        if (event == 0) {
            if (this.level.isClientSide) {
                for (int i = 0; i < 25; ++i) {
                    float r = (float)(param >> 16 & 0xFF) / 255.0f;
                    float g = (float)(param >> 8 & 0xFF) / 255.0f;
                    float b = (float)(param & 0xFF) / 255.0f;
                    SparkleParticleData data1 = SparkleParticleData.sparkle((float)Math.random() * 2.0f + 0.5f, r, g, b, 10);
                    this.level.addParticle((ParticleOptions)data1, (double)this.worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    for (int j = 0; j < 2; ++j) {
                        WispParticleData data = WispParticleData.wisp(0.1f + (float)Math.random() * 0.2f, 0.2f, 0.2f, 0.2f);
                        this.level.addParticle((ParticleOptions)data, (double)this.worldPosition.getX() + 0.7 - Math.random() * 0.4, (double)this.worldPosition.getY() + 0.9 - Math.random() * 0.2, (double)this.worldPosition.getZ() + 0.7 - Math.random() * 0.4, (double)(0.05f - (float)Math.random() * 0.1f), (double)(0.05f + (float)Math.random() * 0.03f), (double)(0.05f - (float)Math.random() * 0.1f));
                    }
                }
                this.level.playLocalSound((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), BotaniaSounds.potionCreate, SoundSource.BLOCKS, 1.0f, 1.5f + (float)Math.random() * 0.25f, false);
            }
            return true;
        }
        return super.triggerEvent(event, param);
    }

    public int getManaCost() {
        Item item;
        ItemStack stack = this.getItemHandler().getItem(0);
        if (this.recipe == null || stack.isEmpty() || !((item = stack.getItem()) instanceof BrewContainer)) {
            return 0;
        }
        BrewContainer container = (BrewContainer)item;
        return container.getManaCost(this.recipe.getBrew(), stack);
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.putInt(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.mana = tag.getInt(TAG_MANA);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(7){

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.getManaCost();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.getManaCost());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public static class WandHud
    implements WandHUD {
        private final BreweryBlockEntity brewery;

        public WandHud(BreweryBlockEntity brewery) {
            this.brewery = brewery;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            int manaToGet = this.brewery.getManaCost();
            if (manaToGet > 0) {
                if (this.brewery.recipe == null) {
                    return;
                }
                int x = mc.getWindow().getGuiScaledWidth() / 2 + 8;
                int y = mc.getWindow().getGuiScaledHeight() / 2 - 12;
                RenderHelper.renderHUDBox(gui, x, y, x + 24, y + 24);
                RenderHelper.renderProgressPie(gui, x + 4, y + 4, (float)this.brewery.mana / (float)manaToGet, this.brewery.recipe.getOutput(this.brewery.getItemHandler().getItem(0)));
            }
        }
    }
}

