/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.brew;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import vazkii.botania.api.BotaniaAPI;

public class Brew {
    private final Supplier<Integer> color;
    private final int cost;
    private final Supplier<List<MobEffectInstance>> effects;
    private boolean canInfuseBloodPendant = true;
    private boolean canInfuseIncense = true;

    public Brew(int color, int cost, MobEffectInstance ... effects) {
        this.color = () -> color;
        this.cost = cost;
        ImmutableList savedEffects = ImmutableList.copyOf((Object[])effects);
        this.effects = () -> Brew.lambda$new$1((List)savedEffects);
    }

    public Brew(int cost, Supplier<List<MobEffectInstance>> effects) {
        this.color = () -> PotionUtils.getColor((Collection)((Collection)effects.get()));
        this.cost = cost;
        this.effects = effects;
    }

    public Brew setNotBloodPendantInfusable() {
        this.canInfuseBloodPendant = false;
        return this;
    }

    public Brew setNotIncenseInfusable() {
        this.canInfuseIncense = false;
        return this;
    }

    public boolean canInfuseBloodPendant() {
        return this.canInfuseBloodPendant;
    }

    public boolean canInfuseIncense() {
        return this.canInfuseIncense;
    }

    public String getTranslationKey() {
        ResourceLocation id = BotaniaAPI.instance().getBrewRegistry().getKey((Object)this);
        return String.format("%s.brew.%s", id.getNamespace(), id.getPath());
    }

    public String getTranslationKey(ItemStack stack) {
        return this.getTranslationKey();
    }

    public int getColor(ItemStack stack) {
        return this.color.get();
    }

    public int getManaCost() {
        return this.cost;
    }

    public int getManaCost(ItemStack stack) {
        return this.getManaCost();
    }

    public List<MobEffectInstance> getPotionEffects(ItemStack stack) {
        return this.effects.get();
    }

    private static /* synthetic */ List lambda$new$1(List savedEffects) {
        return savedEffects;
    }
}

