/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class RunicAltarProvider
extends BotaniaRecipeProvider {
    public RunicAltarProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Botania runic altar recipes";
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        int costTier1 = 5200;
        int costTier2 = 8000;
        int costTier3 = 12000;
        Ingredient manaSteel = Ingredient.of(BotaniaTags.Items.INGOTS_MANASTEEL);
        Ingredient manaDiamond = Ingredient.of(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaPowder = Ingredient.of(BotaniaTags.Items.DUSTS_MANA);
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("water"), new ItemStack((ItemLike)BotaniaItems.runeWater, 2), 5200, manaPowder, manaSteel, Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_MEAL}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SUGAR_CANE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FISHING_ROD})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("fire"), new ItemStack((ItemLike)BotaniaItems.runeFire, 2), 5200, manaPowder, manaSteel, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_BRICK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART})));
        Ingredient stone = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE});
        Ingredient coalBlock = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.COAL_BLOCK});
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("earth"), new ItemStack((ItemLike)BotaniaItems.runeEarth, 2), 5200, manaPowder, manaSteel, stone, coalBlock, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("air"), new ItemStack((ItemLike)BotaniaItems.runeAir, 2), 5200, manaPowder, manaSteel, Ingredient.of((TagKey)ItemTags.WOOL_CARPETS), Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING})));
        Ingredient fire = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeFire});
        Ingredient water = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWater});
        Ingredient earth = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeEarth});
        Ingredient air = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAir});
        Ingredient sapling = Ingredient.of((TagKey)ItemTags.SAPLINGS);
        Ingredient leaves = Ingredient.of((TagKey)ItemTags.LEAVES);
        Ingredient sand = Ingredient.of((TagKey)ItemTags.SAND);
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("spring"), new ItemStack((ItemLike)BotaniaItems.runeSpring), 8000, water, fire, sapling, sapling, sapling, Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("summer"), new ItemStack((ItemLike)BotaniaItems.runeSummer), 8000, earth, air, sand, sand, Ingredient.of((ItemLike[])new ItemLike[]{Items.SLIME_BALL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("autumn"), new ItemStack((ItemLike)BotaniaItems.runeAutumn), 8000, fire, air, leaves, leaves, leaves, Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("winter"), new ItemStack((ItemLike)BotaniaItems.runeWinter), 8000, water, earth, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SNOW_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SNOW_BLOCK}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CAKE})));
        Ingredient spring = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSpring});
        Ingredient summer = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeSummer});
        Ingredient autumn = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeAutumn});
        Ingredient winter = Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.runeWinter});
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("mana"), new ItemStack((ItemLike)BotaniaItems.runeMana), 8000, manaSteel, manaSteel, manaSteel, manaSteel, manaSteel, Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("lust"), new ItemStack((ItemLike)BotaniaItems.runeLust), 12000, manaDiamond, manaDiamond, summer, air));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("gluttony"), new ItemStack((ItemLike)BotaniaItems.runeGluttony), 12000, manaDiamond, manaDiamond, winter, fire));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("greed"), new ItemStack((ItemLike)BotaniaItems.runeGreed), 12000, manaDiamond, manaDiamond, spring, water));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("sloth"), new ItemStack((ItemLike)BotaniaItems.runeSloth), 12000, manaDiamond, manaDiamond, autumn, air));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("wrath"), new ItemStack((ItemLike)BotaniaItems.runeWrath), 12000, manaDiamond, manaDiamond, winter, earth));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("envy"), new ItemStack((ItemLike)BotaniaItems.runeEnvy), 12000, manaDiamond, manaDiamond, winter, water));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("pride"), new ItemStack((ItemLike)BotaniaItems.runePride), 12000, manaDiamond, manaDiamond, summer, fire));
        consumer.accept(new FinishedHeadRecipe(RunicAltarProvider.idFor("head"), new ItemStack((ItemLike)Items.PLAYER_HEAD), 22500, Ingredient.of((ItemLike[])new ItemLike[]{Items.SKELETON_SKULL}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.pixieDust}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_CRYSTALS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NAME_TAG}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})));
    }

    private static ResourceLocation idFor(String s) {
        return ResourceLocationHelper.prefix("runic_altar/" + s);
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final int mana;
        private final Ingredient[] inputs;

        protected FinishedRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
            this.id = id;
            this.output = output;
            this.mana = mana;
            this.inputs = inputs;
        }

        public void serializeRecipeData(JsonObject json) {
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                ingredients.add(ingr.toJson());
            }
            json.addProperty("mana", (Number)this.mana);
            json.add("ingredients", (JsonElement)ingredients);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.RUNE_SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }

    private static class FinishedHeadRecipe
    extends FinishedRecipe {
        private FinishedHeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
            super(id, output, mana, inputs);
        }

        @Override
        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.RUNE_HEAD_SERIALIZER;
        }
    }
}

