/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.RunicAltarRecipe;
import vazkii.botania.common.helper.ItemNBTHelper;

public class HeadRecipe
extends RunicAltarRecipe {
    public HeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        super(id, output, mana, inputs);
    }

    @Override
    public boolean matches(Container inv, @NotNull Level world) {
        boolean matches = super.matches(inv, world);
        if (matches) {
            ItemStack stack;
            for (int i = 0; i < inv.getContainerSize() && !(stack = inv.getItem(i)).isEmpty(); ++i) {
                if (!stack.is(Items.NAME_TAG)) continue;
                String defaultName = Component.translatable((String)Items.NAME_TAG.getDescriptionId()).getString();
                if (!stack.getHoverName().getString().equals(defaultName)) continue;
                return false;
            }
        }
        return matches;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess registries) {
        ItemStack stack = this.getResultItem(registries).copy();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack ingr = inv.getItem(i);
            if (!ingr.is(Items.NAME_TAG)) continue;
            ItemNBTHelper.setString(stack, "SkullOwner", ingr.getHoverName().getString());
            break;
        }
        return stack;
    }

    public static class Serializer
    implements RecipeSerializer<HeadRecipe> {
        @NotNull
        public HeadRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"output"));
            int mana = GsonHelper.getAsInt((JsonObject)json, (String)"mana");
            JsonArray ingrs = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.fromJson((JsonElement)e));
            }
            return new HeadRecipe(id, output, mana, inputs.toArray(new Ingredient[0]));
        }

        public HeadRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.readVarInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.readItem();
            int mana = buf.readVarInt();
            return new HeadRecipe(id, output, mana, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull HeadRecipe recipe) {
            BotaniaRecipeTypes.RUNE_SERIALIZER.toNetwork(buf, (Recipe)recipe);
        }
    }
}

