/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.item.AncientWillItem;
import vazkii.botania.common.item.BotaniaItems;

public class AncientWillRecipeWrapper
implements ICraftingCategoryExtension {
    private final ResourceLocation name;

    public AncientWillRecipeWrapper(AncientWillRecipe recipe) {
        this.name = recipe.getId();
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper helper, @NotNull IFocusGroup focusGroup) {
        List<ItemStack> foci = focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).filter(f -> ((ItemStack)f.getTypedValue().getIngredient()).getItem() instanceof AncientWillItem).map(f -> (ItemStack)f.getTypedValue().getIngredient()).toList();
        List<ItemStack> willStacks = !foci.isEmpty() ? foci : List.of(new ItemStack((ItemLike)BotaniaItems.ancientWillAhrim), new ItemStack((ItemLike)BotaniaItems.ancientWillDharok), new ItemStack((ItemLike)BotaniaItems.ancientWillGuthan), new ItemStack((ItemLike)BotaniaItems.ancientWillTorag), new ItemStack((ItemLike)BotaniaItems.ancientWillVerac), new ItemStack((ItemLike)BotaniaItems.ancientWillKaril));
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
        for (ItemStack will : !foci.isEmpty() ? foci : willStacks) {
            ItemStack stack = new ItemStack((ItemLike)BotaniaItems.terrasteelHelm);
            ((AncientWillContainer)stack.getItem()).addAncientWill(stack, ((AncientWillItem)will.getItem()).type);
            outputStacks.add(stack);
        }
        helper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(Collections.singletonList(new ItemStack((ItemLike)BotaniaItems.terrasteelHelm)), willStacks), 0, 0);
        helper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputStacks);
    }
}

