/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class DebugHandler {
    private static final String PREFIX = ChatFormatting.GREEN + "[Botania] " + ChatFormatting.RESET;

    private DebugHandler() {
    }

    public static void onDrawDebugText(List<String> left) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        if (mc.options.renderDebug && BotaniaConfig.client().debugInfo()) {
            left.add("");
            String version = XplatAbstractions.INSTANCE.getBotaniaVersion();
            left.add(PREFIX + "(CLIENT) netColl: " + ManaNetworkHandler.instance.getAllCollectorsInWorld((Level)world).size() + ", netPool: " + ManaNetworkHandler.instance.getAllPoolsInWorld((Level)world).size() + ", rv: " + version);
            if (Minecraft.getInstance().hasSingleplayerServer()) {
                ResourceKey dim = world.dimension();
                ResourceLocation dimName = dim.location();
                if (mc.getSingleplayerServer() != null) {
                    ServerLevel serverWorld = mc.getSingleplayerServer().getLevel(dim);
                    left.add(PREFIX + String.format("(INTEGRATED SERVER %s) netColl : %d, netPool: %d", dimName, ManaNetworkHandler.instance.getAllCollectorsInWorld((Level)serverWorld).size(), ManaNetworkHandler.instance.getAllPoolsInWorld((Level)serverWorld).size()));
                }
            }
        }
    }
}

