/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.proxy.Proxy;

public class ManasteelArmorItem
extends ArmorItem
implements CustomDamageItem,
PhantomInkable {
    private static final String TAG_PHANTOM_INK = "phantomInk";
    public final ArmorItem.Type type;
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.manasteelHelm), new ItemStack((ItemLike)BotaniaItems.manasteelChest), new ItemStack((ItemLike)BotaniaItems.manasteelLegs), new ItemStack((ItemLike)BotaniaItems.manasteelBoots)});

    public ManasteelArmorItem(ArmorItem.Type type, Item.Properties props) {
        this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
    }

    public ManasteelArmorItem(ArmorItem.Type type, ArmorMaterial mat, Item.Properties props) {
        super(mat, type, props);
        this.type = type;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.isClientSide && stack.getDamageValue() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, this.getManaPerDamage() * 2, true)) {
                stack.setDamageValue(stack.getDamageValue() - 1);
            }
        }
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, this.getManaPerDamage());
    }

    protected int getManaPerDamage() {
        return 70;
    }

    @NotNull
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_manasteel.png";
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        TooltipHandler.addOnShift(list, () -> this.addInformationAfterShift(stack, world, list, flags));
    }

    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        ItemStack[] stacks;
        Player player = Proxy.INSTANCE.getClientPlayer();
        list.add(this.getArmorSetTitle(player));
        this.addArmorSetDescription(stack, list);
        for (ItemStack armor : stacks = this.getArmorSetStacks()) {
            MutableComponent cmp = Component.literal((String)" - ").append(armor.getHoverName());
            EquipmentSlot slot = ((ArmorItem)armor.getItem()).getEquipmentSlot();
            cmp.withStyle(this.hasArmorSetItem(player, slot) ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            list.add((Component)cmp);
        }
        if (this.hasPhantomInk(stack)) {
            list.add((Component)Component.translatable((String)"botaniamisc.hasPhantomInk").withStyle(ChatFormatting.GRAY));
        }
    }

    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    public boolean hasArmorSet(Player player) {
        return this.hasArmorSetItem(player, EquipmentSlot.HEAD) && this.hasArmorSetItem(player, EquipmentSlot.CHEST) && this.hasArmorSetItem(player, EquipmentSlot.LEGS) && this.hasArmorSetItem(player, EquipmentSlot.FEET);
    }

    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null || player.getInventory() == null || player.getInventory().armor == null) {
            return false;
        }
        ItemStack stack = player.getItemBySlot(slot);
        if (stack.isEmpty()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.is(BotaniaItems.manasteelHelm);
            case EquipmentSlot.CHEST -> stack.is(BotaniaItems.manasteelChest);
            case EquipmentSlot.LEGS -> stack.is(BotaniaItems.manasteelLegs);
            case EquipmentSlot.FEET -> stack.is(BotaniaItems.manasteelBoots);
            default -> false;
        };
    }

    private int getSetPiecesEquipped(Player player) {
        int pieces = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.ARMOR || !this.hasArmorSetItem(player, slot)) continue;
            ++pieces;
        }
        return pieces;
    }

    public MutableComponent getArmorSetName() {
        return Component.translatable((String)"botania.armorset.manasteel.name");
    }

    private Component getArmorSetTitle(Player player) {
        MutableComponent end = this.getArmorSetName().append(" (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")").withStyle(ChatFormatting.GRAY);
        return Component.translatable((String)"botaniamisc.armorset").append(" ").append((Component)end);
    }

    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)Component.translatable((String)"botania.armorset.manasteel.desc").withStyle(ChatFormatting.GRAY));
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }
}

