/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.XplatAbstractions;

public final class ManaNetworkHandler
implements ManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final Map<Level, Set<ManaPool>> manaPools = new WeakHashMap<Level, Set<ManaPool>>();
    private final Map<Level, Set<ManaCollector>> manaCollectors = new WeakHashMap<Level, Set<ManaCollector>>();

    public void onNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        switch (type) {
            case COLLECTOR: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaCollectors, thing.getManaReceiverLevel(), (ManaCollector)thing);
                    break;
                }
                this.remove(this.manaCollectors, thing.getManaReceiverLevel(), (ManaCollector)thing);
                break;
            }
            case POOL: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaPools, thing.getManaReceiverLevel(), (ManaPool)thing);
                    break;
                }
                this.remove(this.manaPools, thing.getManaReceiverLevel(), (ManaPool)thing);
            }
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public ManaPool getClosestPool(BlockPos pos, Level world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public ManaCollector getClosestCollector(BlockPos pos, Level world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(Level level, ManaCollector collector) {
        return this.manaCollectors.getOrDefault(level, Collections.emptySet()).contains(collector);
    }

    public boolean isPoolIn(Level level, ManaPool pool) {
        return this.manaPools.getOrDefault(level, Collections.emptySet()).contains(pool);
    }

    @Nullable
    private <T extends ManaReceiver> T getClosest(Set<T> receivers, BlockPos pos, int limit) {
        long minDist = Long.MAX_VALUE;
        long limitSquared = (long)limit * (long)limit;
        ManaReceiver closest = null;
        for (ManaReceiver receiver : receivers) {
            long distance = MathHelper.distSqr((Vec3i)receiver.getManaReceiverPos(), (Vec3i)pos);
            if (distance > limitSquared || distance >= minDist) continue;
            minDist = distance;
            closest = receiver;
        }
        return (T)closest;
    }

    private <T> void remove(Map<Level, Set<T>> map, Level level, T thing) {
        if (!map.containsKey(level)) {
            return;
        }
        Set<T> set = map.get(level);
        set.remove(thing);
        if (set.isEmpty()) {
            map.remove(level);
        }
    }

    private <T> void add(Map<Level, Set<T>> map, Level level, T thing) {
        map.computeIfAbsent(level, k -> new HashSet()).add(thing);
    }

    @Override
    public Set<ManaCollector> getAllCollectorsInWorld(Level world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<ManaPool> getAllPoolsInWorld(Level world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    @Override
    public void fireManaNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        XplatAbstractions.INSTANCE.fireManaNetworkEvent(thing, type, action);
    }

    private <T> Set<T> getAllInWorld(Map<Level, Set<T>> map, Level world) {
        Set<T> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

