/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.OpenCrateBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.RecipeManagerAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class CraftyCrateBlockEntity
extends OpenCrateBlockEntity
implements Wandable {
    private static int recipeEpoch = 0;
    private int signal = 0;
    private ItemStack craftResult = ItemStack.EMPTY;
    private final Queue<ResourceLocation> lastRecipes = new ArrayDeque<ResourceLocation>();
    private boolean dirty;
    private boolean matchFailed;
    private int lastRecipeEpoch = recipeEpoch;

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(PackType.SERVER_DATA, ResourceLocationHelper.prefix("craft_crate_epoch_counter"), (PreparableReloadListener)((ResourceManagerReloadListener)mgr -> ++recipeEpoch));
    }

    public CraftyCrateBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CRAFT_CRATE, pos, state);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(9){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean canPlaceItem(int slot, ItemStack stack) {
                return !CraftyCrateBlockEntity.this.isLocked(slot);
            }
        };
    }

    public CraftyCratePattern getPattern() {
        BlockState state = this.getBlockState();
        if (!state.is(BotaniaBlocks.craftCrate)) {
            return CraftyCratePattern.NONE;
        }
        return (CraftyCratePattern)((Object)state.getValue(BotaniaStateProperties.CRATE_PATTERN));
    }

    private boolean isLocked(int slot) {
        return this.getPattern().openSlots.get(slot) == false;
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, CraftyCrateBlockEntity self) {
        int newSignal;
        if (recipeEpoch != self.lastRecipeEpoch) {
            self.lastRecipeEpoch = recipeEpoch;
            self.matchFailed = false;
        }
        if (!self.matchFailed && self.canEject() && self.isFull() && self.craft(true, null)) {
            self.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (self.isLocked(newSignal) || !self.getItemHandler().getItem(newSignal).isEmpty()); ++newSignal) {
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.updateNeighbourForOutputSignal(worldPosition, state.getBlock());
        }
        if (self.dirty) {
            self.dirty = false;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
    }

    private boolean craft(boolean fullCheck, @Nullable Player player) {
        this.level.getProfiler().push("craft");
        if (fullCheck && !this.isFull()) {
            return false;
        }
        TransientCraftingContainer craft = new TransientCraftingContainer(new AbstractContainerMenu(MenuType.CRAFTING, -1){

            @NotNull
            public ItemStack quickMoveStack(@NotNull Player player, int i) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(@NotNull Player player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < craft.getContainerSize(); ++i) {
            ItemStack stack = this.getItemHandler().getItem(i);
            if (stack.isEmpty() || this.isLocked(i) || stack.is(BotaniaItems.placeholder)) continue;
            craft.setItem(i, stack);
        }
        Optional<CraftingRecipe> matchingRecipe = this.getMatchingRecipe((CraftingContainer)craft);
        matchingRecipe.ifPresent(arg_0 -> this.lambda$craft$1((CraftingContainer)craft, player, arg_0));
        if (matchingRecipe.isEmpty()) {
            this.matchFailed = true;
        }
        this.level.getProfiler().pop();
        return matchingRecipe.isPresent() && !this.craftResult.isEmpty();
    }

    private Optional<CraftingRecipe> getMatchingRecipe(CraftingContainer craft) {
        for (ResourceLocation currentRecipe : this.lastRecipes) {
            Recipe recipe = (Recipe)((RecipeManagerAccessor)this.level.getRecipeManager()).botania_getAll(RecipeType.CRAFTING).get(currentRecipe);
            if (!(recipe instanceof CraftingRecipe)) continue;
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            if (!recipe.matches((Container)craft, this.level)) continue;
            return Optional.of(craftingRecipe);
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)craft, this.level);
        if (recipe.isPresent()) {
            if (this.lastRecipes.size() >= 8) {
                this.lastRecipes.remove();
            }
            this.lastRecipes.add(((CraftingRecipe)recipe.get()).getId());
            return recipe;
        }
        return Optional.empty();
    }

    boolean isFull() {
        for (int i = 0; i < this.getItemHandler().getContainerSize(); ++i) {
            if (this.isLocked(i) || !this.getItemHandler().getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            ItemStack stack = this.getItemHandler().getItem(i);
            if (stack.isEmpty()) continue;
            this.eject(stack, false);
            this.getItemHandler().setItem(i, ItemStack.EMPTY);
        }
        if (!this.craftResult.isEmpty()) {
            this.eject(this.craftResult, false);
            this.craftResult = ItemStack.EMPTY;
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (!this.getLevel().isClientSide && this.canEject()) {
            this.craft(false, player);
            this.ejectAll();
        }
        return true;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.dirty = true;
            this.matchFailed = false;
        }
    }

    public int getSignal() {
        return this.signal;
    }

    private /* synthetic */ void lambda$craft$1(CraftingContainer craft, Player player, CraftingRecipe recipe) {
        ItemStack result = recipe.assemble((Container)craft, this.getLevel().registryAccess());
        if (result.isEmpty()) {
            this.matchFailed = true;
            return;
        }
        if (player != null) {
            player.triggerRecipeCrafted((Recipe)recipe, List.of(result));
            result.onCraftedBy(this.level, player, result.getCount());
        }
        Container handler = this.getItemHandler();
        NonNullList remainders = recipe.getRemainingItems((Container)craft);
        for (int i = 0; i < craft.getContainerSize(); ++i) {
            ItemStack s = (ItemStack)remainders.get(i);
            ItemStack inSlot = handler.getItem(i);
            if (inSlot.isEmpty() && s.isEmpty() || !inSlot.isEmpty() && inSlot.is(BotaniaItems.placeholder)) continue;
            handler.setItem(i, s);
        }
        this.craftResult = result;
    }

    public static class WandHud
    implements WandHUD {
        private final CraftyCrateBlockEntity crate;

        public WandHud(CraftyCrateBlockEntity crate) {
            this.crate = crate;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            int width = 52;
            int height = 52;
            int xc = mc.getWindow().getGuiScaledWidth() / 2 + 12;
            int yc = mc.getWindow().getGuiScaledHeight() / 2 - height / 2;
            RenderHelper.renderHUDBox(gui, xc - 4, yc - 4, xc + width + 4, yc + height + 4);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    boolean enabled = true;
                    if (this.crate.getPattern() != CraftyCratePattern.NONE) {
                        enabled = this.crate.getPattern().openSlots.get(index);
                    }
                    gui.fill(xp, yp, xp + 16, yp + 16, enabled ? 0x22FFFFFF : 0x22FF0000);
                    ItemStack item = this.crate.getItemHandler().getItem(index);
                    gui.renderItem(item, xp, yp);
                }
            }
        }
    }
}

