/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.helper.MathHelper;

public class FlameRingEntity
extends Entity {
    public FlameRingEntity(EntityType<FlameRingEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData() {
    }

    public void baseTick() {
        super.baseTick();
        float radius = 5.0f;
        float renderRadius = (float)((double)radius - Math.random());
        for (int i = 0; i < Math.min(90, this.tickCount); ++i) {
            float a = i;
            if (a % 2.0f == 0.0f) {
                a = 45.0f + a;
            }
            if (this.level().random.nextInt(this.tickCount < 90 ? 8 : 20) != 0) continue;
            float rad = (float)((double)(a * 4.0f) * Math.PI / 180.0);
            double x = Math.cos(rad) * (double)renderRadius;
            double z = Math.sin(rad) * (double)renderRadius;
            WispParticleData data1 = WispParticleData.wisp(0.65f + (float)Math.random() * 0.45f, 1.0f, (float)Math.random() * 0.25f, (float)Math.random() * 0.25f);
            this.level().addParticle((ParticleOptions)data1, this.getX() + x, this.getY() - 0.2, this.getZ() + z, (double)((float)(Math.random() - 0.5) * 0.15f), (double)(0.055f + (float)Math.random() * 0.025f), (double)((float)(Math.random() - 0.5) * 0.15f));
            float gs = (float)Math.random() * 0.15f;
            float smokeRadius = (float)((double)renderRadius - Math.random() * (double)renderRadius * 0.9);
            x = Math.cos(rad) * (double)smokeRadius;
            z = Math.sin(rad) * (double)smokeRadius;
            WispParticleData data = WispParticleData.wisp(0.65f + (float)Math.random() * 0.45f, gs, gs, gs, 1.0f);
            this.level().addParticle((ParticleOptions)data, this.getX() + x, this.getY() - 0.2, this.getZ() + z, 0.0, (double)(-(-0.155f - (float)Math.random() * 0.025f)), 0.0);
        }
        if (this.level().random.nextInt(20) == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if (this.level().isClientSide) {
            return;
        }
        if (this.tickCount >= 300) {
            this.discard();
            return;
        }
        if (this.tickCount > 45) {
            AABB boundingBox = new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()).inflate((double)radius, (double)radius, (double)radius);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, boundingBox);
            if (entities.isEmpty()) {
                return;
            }
            for (LivingEntity entity : entities) {
                if (entity == null || MathHelper.pointDistancePlane(this.getX(), this.getZ(), entity.getX(), entity.getZ()) > radius) continue;
                entity.setSecondsOnFire(4);
            }
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag var1) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag var1) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

