/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.block.mana.ManaPrismBlock;

public class ManaPumpBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape X_SHAPE = ManaPumpBlock.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    private static final VoxelShape Z_SHAPE = ManaPumpBlock.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);

    public ManaPumpBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((ManaPumpBlockEntity)world.getBlockEntity((BlockPos)pos)).comparator;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaPumpBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ManaPumpBlock.createTickerHelper(type, BotaniaBlockEntities.PUMP, ManaPumpBlockEntity::commonTick);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (world.hasNeighborSignal(pos)) {
            ManaPrismBlock.redstoneParticlesInShape(state, world, pos, rand);
        }
    }
}

