/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfheimPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfheimPortalTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.TriPredicate;

public class AlfheimPortalBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> {
        record 1Matcher(TagKey<Block> tag, Direction.Axis displayedRotation, Block defaultBlock) implements IStateMatcher
        {
            public BlockState getDisplayedState(long ticks) {
                List<Block> blocks = StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag).spliterator(), false).map(Holder::value).toList();
                if (blocks.isEmpty()) {
                    return Blocks.BEDROCK.defaultBlockState();
                }
                BlockState block = blocks.contains(this.defaultBlock) ? this.defaultBlock.defaultBlockState() : blocks.get((int)(ticks / 20L % (long)blocks.size())).defaultBlockState();
                return block.hasProperty((Property)BlockStateProperties.AXIS) ? (BlockState)block.setValue((Property)BlockStateProperties.AXIS, (Comparable)this.displayedRotation()) : block;
            }

            public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
                return (blockGetter, pos, state) -> state.is(this.tag());
            }
        }
        1Matcher horizontal = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS, Direction.Axis.X, BotaniaBlocks.livingwoodLog);
        1Matcher vertical = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS, Direction.Axis.Y, BotaniaBlocks.livingwoodLog);
        1Matcher horizontalGlimmer = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, Direction.Axis.X, BotaniaBlocks.livingwoodLogGlimmering);
        1Matcher verticalGlimmer = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, Direction.Axis.Y, BotaniaBlocks.livingwoodLogGlimmering);
        return PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"_", "w", "g", "w", "_"}, {"W", " ", " ", " ", "W"}, {"G", " ", " ", " ", "G"}, {"W", " ", " ", " ", "W"}, {"_", "w", "0", "w", "_"}}, new Object[]{Character.valueOf('W'), vertical, Character.valueOf('w'), horizontal, Character.valueOf('G'), verticalGlimmer, Character.valueOf('g'), horizontalGlimmer, Character.valueOf('0'), BotaniaBlocks.alfPortal});
    });
    public static final int MANA_COST = 500;
    public static final int MANA_COST_OPENING = 200000;
    public static final int MIN_REQUIRED_PYLONS = 2;
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    private final List<ItemStack> stacksIn = new ArrayList<ItemStack>();
    private final List<BlockPos> cachedPylonPositions = new ArrayList<BlockPos>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean explode = false;
    @Nullable
    private UUID breadPlayer = null;

    public AlfheimPortalBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ALF_PORTAL, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState blockState, AlfheimPortalBlockEntity self) {
        AlfheimPortalState state = (AlfheimPortalState)((Object)blockState.getValue(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF) {
            self.ticksOpen = 0;
            return;
        }
        AlfheimPortalState newState = self.getValidState(state);
        ++self.ticksOpen;
        AABB aabb = self.getPortalAABB(state);
        boolean open = self.ticksOpen > 60;
        XplatAbstractions.INSTANCE.fireElvenPortalUpdateEvent(self, aabb, open, self.stacksIn);
        if (self.ticksOpen > 60) {
            ++self.ticksSinceLastItem;
            if (level.isClientSide && BotaniaConfig.client().elfPortalParticlesEnabled()) {
                self.blockParticle(state);
            }
            List items = level.getEntitiesOfClass(ItemEntity.class, aabb);
            if (!level.isClientSide) {
                for (ItemEntity item : items) {
                    if (!item.isAlive()) continue;
                    ItemStack stack = item.getItem();
                    if (XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).elvenPortalSpawned) continue;
                    item.discard();
                    if (self.validateItemUsage(item)) {
                        self.addItem(stack);
                    }
                    self.ticksSinceLastItem = 0;
                }
            }
            if (!level.isClientSide && !self.stacksIn.isEmpty() && self.ticksSinceLastItem >= 4) {
                self.resolveRecipes();
            }
        }
        if (self.closeNow) {
            if (!level.isClientSide) {
                level.setBlockAndUpdate(worldPosition, BotaniaBlocks.alfPortal.defaultBlockState());
            }
            for (int i = 0; i < 36; ++i) {
                self.blockParticle(state);
            }
            self.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfheimPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    self.blockParticle(state);
                }
            }
            if (!level.isClientSide) {
                level.setBlockAndUpdate(worldPosition, (BlockState)blockState.setValue(BotaniaStateProperties.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            }
        } else if (self.explode) {
            Player entity;
            level.explode(null, (double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 2.0, (double)worldPosition.getZ() + 0.5, 3.0f, Level.ExplosionInteraction.NONE);
            self.explode = false;
            if (!level.isClientSide && self.breadPlayer != null && (entity = level.getPlayerByUUID(self.breadPlayer)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AlfheimPortalBreadTrigger.INSTANCE.trigger(serverPlayer, worldPosition);
            }
            self.breadPlayer = null;
        }
    }

    private boolean validateItemUsage(ItemEntity entity) {
        ItemStack inputStack = entity.getItem();
        for (Recipe recipe : BotaniaRecipeTypes.getRecipes(this.level, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            ElvenTradeRecipe tradeRecipe;
            if (!(recipe instanceof ElvenTradeRecipe) || !(tradeRecipe = (ElvenTradeRecipe)recipe).containsItem(inputStack)) continue;
            return true;
        }
        if (inputStack.is(Items.BREAD)) {
            this.explode = true;
            if (entity.getOwner() != null) {
                this.breadPlayer = entity.getOwner().getUUID();
            }
        }
        return false;
    }

    private void blockParticle(AlfheimPortalState state) {
        int rnd = this.level.random.nextInt(9);
        double dh = rnd / 3 - 1;
        double dy = rnd % 3 + 1;
        double dx = state == AlfheimPortalState.ON_X ? 0.0 : dh;
        double dz = state == AlfheimPortalState.ON_Z ? 0.0 : dh;
        float motionMul = 0.2f;
        WispParticleData data = WispParticleData.wisp((float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25));
        this.level.addParticle((ParticleOptions)data, (double)this.getBlockPos().getX() + dx, (double)this.getBlockPos().getY() + dy, (double)this.getBlockPos().getZ() + dz, (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul));
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        AlfheimPortalState newState;
        AlfheimPortalState state = (AlfheimPortalState)((Object)this.getBlockState().getValue(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF && (newState = this.getValidState(state)) != AlfheimPortalState.OFF) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(BotaniaStateProperties.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AlfheimPortalTrigger.INSTANCE.trigger(serverPlayer, serverPlayer.serverLevel(), this.getBlockPos(), stack);
            }
            return true;
        }
        return false;
    }

    private AABB getPortalAABB(AlfheimPortalState state) {
        return state == AlfheimPortalState.ON_X ? new AABB(this.worldPosition.offset(0, 1, -1), this.worldPosition.offset(1, 4, 2)) : new AABB(this.worldPosition.offset(-1, 1, 0), this.worldPosition.offset(2, 4, 1));
    }

    private void addItem(ItemStack stack) {
        int size = stack.getCount();
        stack.setCount(1);
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.copy());
        }
    }

    public static Collection<ElvenTradeRecipe> elvenTradeRecipes(Level world) {
        return BotaniaRecipeTypes.getRecipes(world, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values();
    }

    private void resolveRecipes() {
        List<BlockPos> pylons = this.locatePylons(true);
        for (Recipe recipe : BotaniaRecipeTypes.getRecipes(this.level, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            ElvenTradeRecipe recipe2;
            Optional<List<ItemStack>> match;
            if (!(recipe instanceof ElvenTradeRecipe) || !(match = (recipe2 = (ElvenTradeRecipe)recipe).match(this.stacksIn)).isPresent()) continue;
            if (!this.consumeMana(pylons, 500, false)) break;
            List<ItemStack> inputs = match.get();
            for (ItemStack stack : inputs) {
                this.stacksIn.remove(stack);
            }
            for (ItemStack output : recipe2.getOutputs(inputs)) {
                this.spawnItem(output.copy());
            }
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, stack);
        XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).elvenPortalSpawned = true;
        this.level.addFreshEntity((Entity)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    public void saveAdditional(CompoundTag cmp) {
        super.saveAdditional(cmp);
        cmp.putInt(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            CompoundTag stackcmp = stack.save(new CompoundTag());
            cmp.put(TAG_STACK + i, (Tag)stackcmp);
            ++i;
        }
    }

    @Override
    public void load(@NotNull CompoundTag cmp) {
        super.load(cmp);
        int count = cmp.getInt(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            CompoundTag stackcmp = cmp.getCompound(TAG_STACK + i);
            ItemStack stack = ItemStack.of((CompoundTag)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.putInt(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.putInt(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.ticksOpen = cmp.getInt(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.getInt(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private static Rotation getStateRotation(AlfheimPortalState state) {
        return switch (state) {
            case AlfheimPortalState.ON_X -> Rotation.CLOCKWISE_90;
            case AlfheimPortalState.ON_Z -> Rotation.NONE;
            default -> null;
        };
    }

    private AlfheimPortalState getValidState(AlfheimPortalState oldState) {
        Rotation rot;
        if (oldState != AlfheimPortalState.OFF) {
            Rotation oldRot = AlfheimPortalBlockEntity.getStateRotation(oldState);
            if (!MULTIBLOCK.get().validate(this.level, this.getBlockPos(), oldRot)) {
                return AlfheimPortalState.OFF;
            }
            rot = oldRot;
        } else {
            rot = MULTIBLOCK.get().validate(this.level, this.getBlockPos());
        }
        if (rot == null) {
            return AlfheimPortalState.OFF;
        }
        this.lightPylons();
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> AlfheimPortalState.ON_Z;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> AlfheimPortalState.ON_X;
        };
    }

    public List<BlockPos> locatePylons(boolean rescanNow) {
        if (!rescanNow && this.cachedPylonPositions.size() >= 2) {
            ArrayList<BlockPos> cachedResult = new ArrayList<BlockPos>();
            for (BlockPos pos : this.cachedPylonPositions) {
                if (!this.isValidPylonPosition(pos)) continue;
                cachedResult.add(pos);
            }
            if (cachedResult.size() >= 2) {
                return cachedResult;
            }
        }
        int range = 5;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getBlockPos().offset(-range, -range, -range), (BlockPos)this.getBlockPos().offset(range, range, range))) {
            if (!this.isValidPylonPosition(pos)) continue;
            result.add(pos.immutable());
        }
        this.cachedPylonPositions.clear();
        this.cachedPylonPositions.addAll(result);
        return result;
    }

    private boolean isValidPylonPosition(BlockPos pos) {
        return this.getLevel().hasChunkAt(pos) && this.getLevel().getBlockState(pos).is(BotaniaBlocks.naturaPylon) && this.getLevel().getBlockState(pos.below()).getBlock() instanceof ManaPoolBlock;
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        boolean finishOpening = this.ticksOpen == 50;
        List<BlockPos> pylons = this.locatePylons(finishOpening);
        for (BlockPos pos : pylons) {
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (!(tile instanceof PylonBlockEntity)) continue;
            PylonBlockEntity pylon = (PylonBlockEntity)tile;
            pylon.activated = true;
            pylon.centerPos = this.getBlockPos();
        }
        if (finishOpening) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(List<BlockPos> pylons, int totalCost, boolean close) {
        ArrayList<ManaPoolBlockEntity> consumePools = new ArrayList<ManaPoolBlockEntity>();
        int consumed = 0;
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (BlockPos pos : pylons) {
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (tile instanceof PylonBlockEntity) {
                PylonBlockEntity pylon = (PylonBlockEntity)tile;
                pylon.activated = true;
                pylon.centerPos = this.getBlockPos();
            }
            if (!((tile = this.level.getBlockEntity(pos.below())) instanceof ManaPoolBlockEntity)) continue;
            ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.level.isClientSide) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (ManaPoolBlockEntity pool : consumePools) {
                pool.receiveMana(-costPer);
                pool.craftingEffect(false);
            }
            return true;
        }
        return false;
    }
}

