/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ExtrapolatedBucketItem
extends Item {
    public ExtrapolatedBucketItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = ExtrapolatedBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(blockPos2, direction, itemStack)) {
            BucketPickup bucketPickup;
            ItemStack itemStack2;
            BlockState blockState = level.getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (block instanceof BucketPickup && !(itemStack2 = (bucketPickup = (BucketPickup)block).pickupBlock((LevelAccessor)level, blockPos, blockState)).isEmpty()) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                bucketPickup.getPickupSound().ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
                for (int x = 0; x < 5; ++x) {
                    level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)blockPos.getX() + Math.random(), (double)blockPos.getY() + Math.random(), (double)blockPos.getZ() + Math.random(), 0.0, 0.0, 0.0);
                }
                level.gameEvent((Entity)player, GameEvent.FLUID_PICKUP, blockPos);
                ItemStack itemStack3 = itemStack;
                if (!level.isClientSide) {
                    CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemStack2);
                }
                return InteractionResultHolder.sidedSuccess((Object)itemStack3, (boolean)level.isClientSide());
            }
            return InteractionResultHolder.fail((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }
}

