/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.ManaSparkEntity;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.lib.BotaniaTags;

public class CorporeaSparkEntity
extends SparkBaseEntity
implements CorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final String TAG_CREATIVE = "creative";
    private static final EntityDataAccessor<Boolean> MASTER = SynchedEntityData.defineId(CorporeaSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CREATIVE = SynchedEntityData.defineId(CorporeaSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private CorporeaSpark master;
    private Set<CorporeaSpark> connections = new LinkedHashSet<CorporeaSpark>();
    private List<CorporeaSpark> relatives = new ArrayList<CorporeaSpark>();
    private boolean firstTick = true;

    public CorporeaSparkEntity(EntityType<CorporeaSparkEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(MASTER, (Object)false);
        this.entityData.define(CREATIVE, (Object)false);
    }

    @NotNull
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getSparkItem());
    }

    public void tick() {
        if (this.level().isClientSide) {
            return;
        }
        CorporeaNode node = this.getSparkNode();
        if (node instanceof DummyCorporeaNode && !this.level().getBlockState(this.getAttachPos()).is(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (!(this.master == null || this.master.entity().isAlive() && this.master.getNetwork() == this.getNetwork())) {
            this.master = null;
        }
    }

    private void dropAndKill() {
        this.spawnAtLocation(new ItemStack((ItemLike)this.getSparkItem()), 0.0f);
        this.discard();
    }

    protected Item getSparkItem() {
        return this.isCreative() ? BotaniaItems.corporeaSparkCreative : (this.isMaster() ? BotaniaItems.corporeaSparkMaster : BotaniaItems.corporeaSpark);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void introduceNearbyTo(Set<CorporeaSpark> network, CorporeaSpark master) {
        this.relatives.clear();
        for (CorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || network.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || !spark.entity().isAlive()) continue;
            network.add(spark);
            this.relatives.add(spark);
            spark.introduceNearbyTo(network, master);
        }
        this.master = master;
        this.connections = network;
    }

    private List<CorporeaSpark> getNearbySparks() {
        return this.level().getEntitiesOfClass(Entity.class, new AABB(this.getX() - 8.0, this.getY() - 8.0, this.getZ() - 8.0, this.getX() + 8.0, this.getY() + 8.0, this.getZ() + 8.0), (Predicate)Predicates.instanceOf(CorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new LinkedHashSet<CorporeaSpark>();
        this.relatives = new ArrayList<CorporeaSpark>();
        if (this.master != null) {
            CorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.introduceNearbyTo(new LinkedHashSet<CorporeaSpark>(), oldMaster);
        }
    }

    private void findNetwork() {
        for (CorporeaSpark spark : this.getNearbySparks()) {
            CorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || !spark.entity().isAlive() || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(Player player, List<CorporeaSpark> checked, CorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<CorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            ManaSparkEntity.particleBeam(player, spark.entity(), spark.getMaster().entity());
        } else {
            for (CorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                ManaSparkEntity.particleBeam(player, spark.entity(), endSpark.entity());
                checked.add(endSpark);
                CorporeaSparkEntity.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public CorporeaNode getSparkNode() {
        return CorporeaNodeDetectors.findNode(this.level(), this);
    }

    @Override
    public Set<CorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<CorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(ItemStack stack) {
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), this.getX(), this.getY(), this.getZ(), 10, 0.125, 0.125, 0.125, 0.05);
    }

    @Override
    public void onItemsRequested(List<ItemStack> stacks) {
        ArrayList<Item> shownItems = new ArrayList<Item>();
        for (ItemStack stack : stacks) {
            if (shownItems.contains(stack.getItem())) continue;
            shownItems.add(stack.getItem());
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), this.getX(), this.getY(), this.getZ(), 10, 0.125, 0.125, 0.125, 0.05);
        }
    }

    @Override
    public CorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.entityData.set(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.entityData.get(MASTER);
    }

    public void setCreative(boolean creative) {
        this.entityData.set(CREATIVE, (Object)creative);
    }

    @Override
    public boolean isCreative() {
        return (Boolean)this.entityData.get(CREATIVE);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isAlive() && !stack.isEmpty()) {
            if (stack.getItem() instanceof WandOfTheForestItem) {
                if (!this.level().isClientSide) {
                    if (player.isShiftKeyDown()) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        CorporeaSparkEntity.displayRelatives(player, new ArrayList<CorporeaSpark>(), this.master);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            Item item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                DyeColor color = dye.getDyeColor();
                if (color != this.getNetwork()) {
                    if (!this.level().isClientSide) {
                        this.setNetwork(color);
                        stack.shrink(1);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            } else if (stack.is(BotaniaItems.phantomInk)) {
                if (!this.level().isClientSide) {
                    this.setInvisible(true);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void setNetwork(DyeColor color) {
        if (color == this.getNetwork()) {
            return;
        }
        super.setNetwork(color);
        if (!this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
        }
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.setMaster(cmp.getBoolean(TAG_MASTER));
        this.setCreative(cmp.getBoolean(TAG_CREATIVE));
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putBoolean(TAG_MASTER, this.isMaster());
        cmp.putBoolean(TAG_CREATIVE, this.isCreative());
    }

    public record WandHud(CorporeaSparkEntity entity) implements WandHUD
    {
        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack sparkStack = new ItemStack((ItemLike)this.entity.getSparkItem());
            DyeColor networkColor = this.entity.getNetwork();
            MutableComponent networkColorName = Component.translatable((String)("color.minecraft." + networkColor.getName())).withStyle(ChatFormatting.ITALIC);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);
            int width = 4 + Math.max(mc.font.width((FormattedText)networkColorName), RenderHelper.itemWithNameWidth(mc, sparkStack));
            int networkColorTextStart = mc.font.width((FormattedText)networkColorName) / 2;
            int centerX = mc.getWindow().getGuiScaledWidth() / 2;
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 38);
            RenderHelper.renderItemWithNameCentered(gui, mc, sparkStack, centerY + 10, textColor);
            gui.drawString(mc.font, (Component)networkColorName, centerX - networkColorTextStart, centerY + 28, textColor);
        }
    }
}

