/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.xplat.XplatAbstractions;

@Mixin(value={Mob.class})
public class MobMixin {
    @ModifyVariable(method={"checkDespawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/MobCategory;getDespawnDistance()I", ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;distanceToSqr(Lnet/minecraft/world/entity/Entity;)D"), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;removeWhenFarAway(D)Z")))
    private double reduceDistToNearestPlayer(double distToNearestPlayerSquared) {
        Mob thisMob = (Mob)this;
        LooniumComponent looniumComponent = XplatAbstractions.INSTANCE.looniumComponent((LivingEntity)thisMob);
        if (looniumComponent != null && looniumComponent.isSlowDespawn()) {
            double justUnderDespawnDistance = thisMob.getType().getCategory().getDespawnDistance() - 1;
            return Math.min(justUnderDespawnDistance * justUnderDespawnDistance, distToNearestPlayerSquared);
        }
        return distToNearestPlayerSquared;
    }
}

