/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class ConfigDataManagerImpl
implements ConfigDataManager {
    private final Map<ResourceLocation, LooniumStructureConfiguration> looniumConfigs = new HashMap<ResourceLocation, LooniumStructureConfiguration>();

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(PackType.SERVER_DATA, ResourceLocationHelper.prefix("configdata"), new ConfigDataManagerImpl());
    }

    @Override
    @Nullable
    public LooniumStructureConfiguration getEffectiveLooniumStructureConfiguration(ResourceLocation id) {
        LooniumStructureConfiguration configuration = this.looniumConfigs.get(id);
        return configuration != null ? configuration.getEffectiveConfig(this.looniumConfigs::get) : null;
    }

    private static void validateLooniumConfig(Map<ResourceLocation, LooniumStructureConfiguration> map) {
        HashSet<ResourceLocation> errorEntries = new HashSet<ResourceLocation>();
        LinkedHashSet<ResourceLocation> visitedEntries = new LinkedHashSet<ResourceLocation>();
        do {
            errorEntries.clear();
            for (Map.Entry<ResourceLocation, LooniumStructureConfiguration> entry : map.entrySet()) {
                ResourceLocation parent;
                ResourceLocation id = entry.getKey();
                if (id.equals((Object)(parent = entry.getValue().parent))) {
                    BotaniaAPI.LOGGER.warn("Ignoring Loonium structure configuration, because it specified itself as parent: {}", (Object)id);
                    errorEntries.add(id);
                    continue;
                }
                visitedEntries.clear();
                if (ConfigDataManagerImpl.findTopmostParent(map, id, parent, visitedEntries)) continue;
                BotaniaAPI.LOGGER.warn("Ignoring Loonium structure configuration(s) without top-most parent: {}", visitedEntries);
                errorEntries.addAll(visitedEntries);
                break;
            }
            errorEntries.forEach(map::remove);
        } while (!errorEntries.isEmpty() && !map.isEmpty());
        if (!map.containsKey(LooniumStructureConfiguration.DEFAULT_CONFIG_ID)) {
            BotaniaAPI.LOGGER.error("Default Loonium configuration not found!");
        }
    }

    private static boolean findTopmostParent(Map<ResourceLocation, LooniumStructureConfiguration> map, ResourceLocation id, ResourceLocation parent, Set<ResourceLocation> visitedEntries) {
        if (!visitedEntries.add(id)) {
            BotaniaAPI.LOGGER.warn("Cyclic dependency between Loonium structure configurations detected: {}", visitedEntries);
            return false;
        }
        if (parent == null) {
            return true;
        }
        LooniumStructureConfiguration parentConfig = map.get(parent);
        return parentConfig != null && ConfigDataManagerImpl.findTopmostParent(map, parent, parentConfig.parent, visitedEntries);
    }

    private void applyLooniumConfig(Map<ResourceLocation, LooniumStructureConfiguration> looniumConfigs) {
        BotaniaAPI.LOGGER.info("Loaded {} Loonium configurations", (Object)looniumConfigs.size());
        this.looniumConfigs.putAll(looniumConfigs);
    }

    @NotNull
    public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier barrier, @NotNull ResourceManager manager, @NotNull ProfilerFiller prepProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        CompletableFuture<Void> looniumTask = this.scheduleConfigParse(barrier, manager, backgroundExecutor, gameExecutor, ConfigDataType.LOONUIM);
        return CompletableFuture.allOf(looniumTask).thenRun(() -> BotaniaAPI.instance().setConfigData(this));
    }

    private <T> CompletableFuture<Void> scheduleConfigParse(PreparableReloadListener.PreparationBarrier barrier, ResourceManager manager, Executor backgroundExecutor, Executor gameExecutor, ConfigDataType<T> type) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, JsonElement> resourceMap = new HashMap<ResourceLocation, JsonElement>();
            SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)manager, (String)type.directory, (Gson)new Gson(), resourceMap);
            HashMap configs = new HashMap(resourceMap.size());
            resourceMap.forEach((id, jsonElement) -> {
                BotaniaAPI.LOGGER.debug("Parsing {} config '{}'", (Object)type.directory, id);
                type.codec.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().ifPresent(c -> configs.put(id, c));
            });
            type.validateFunction.accept(configs);
            return configs;
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenAcceptAsync(c -> type.applyFunction.accept(this, (Map<ResourceLocation, ConfigDataManagerImpl>)c), gameExecutor);
    }

    private record ConfigDataType<T>(Codec<T> codec, String directory, Consumer<Map<ResourceLocation, T>> validateFunction, BiConsumer<ConfigDataManagerImpl, Map<ResourceLocation, T>> applyFunction) {
        private static final ConfigDataType<LooniumStructureConfiguration> LOONUIM = new ConfigDataType<LooniumStructureConfiguration>(LooniumStructureConfiguration.CODEC, "loonium_config", ConfigDataManagerImpl::validateLooniumConfig, ConfigDataManagerImpl::applyLooniumConfig);
    }
}

