/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.IncenseStickItem;

public class IncensePlateBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements WorldlyContainer {
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_BURNING = "burning";
    private static final int RANGE = 32;
    private int timeLeft = 0;
    public boolean burning = false;
    public int comparatorOutput = 0;

    public IncensePlateBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.INCENSE_PLATE, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, IncensePlateBlockEntity self) {
        ItemStack stack = self.getItemHandler().getItem(0);
        if (!stack.isEmpty() && self.burning) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && self.timeLeft > 1) {
                self.timeLeft = 1;
                self.spawnSmokeParticles();
            }
            Brew brew = ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack);
            MobEffectInstance effect = brew.getPotionEffects(stack).get(0);
            if (self.timeLeft > 0) {
                --self.timeLeft;
                if (!level.isClientSide) {
                    List players = level.getEntitiesOfClass(Player.class, new AABB((double)worldPosition.getX() + 0.5 - 32.0, (double)worldPosition.getY() + 0.5 - 32.0, (double)worldPosition.getZ() + 0.5 - 32.0, (double)worldPosition.getX() + 0.5 + 32.0, (double)worldPosition.getY() + 0.5 + 32.0, (double)worldPosition.getZ() + 0.5 + 32.0));
                    for (Player player : players) {
                        boolean nightVision;
                        MobEffectInstance currentEffect = player.getEffect(effect.getEffect());
                        boolean bl = nightVision = effect.getEffect() == MobEffects.NIGHT_VISION;
                        if (currentEffect != null && currentEffect.getDuration() >= (nightVision ? 205 : 3)) continue;
                        MobEffectInstance applyEffect = new MobEffectInstance(effect.getEffect(), nightVision ? 285 : 80, effect.getAmplifier(), true, true);
                        player.addEffect(applyEffect);
                    }
                    if (level.random.nextInt(20) == 0) {
                        level.playSound(null, worldPosition, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 0.1f, 1.0f);
                    }
                } else {
                    double x = (double)worldPosition.getX() + 0.5;
                    double y = (double)worldPosition.getY() + 0.5;
                    double z = (double)worldPosition.getZ() + 0.5;
                    int color = brew.getColor(stack);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    WispParticleData data1 = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, r, g, b);
                    level.addParticle((ParticleOptions)data1, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.005f), (double)(0.005f - (float)Math.random() * 0.01f));
                    WispParticleData data = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, 0.2f, 0.2f, 0.2f);
                    level.addParticle((ParticleOptions)data, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.001f), (double)(0.005f - (float)Math.random() * 0.01f));
                }
            } else {
                self.getItemHandler().setItem(0, ItemStack.EMPTY);
                self.burning = false;
                level.gameEvent(null, GameEvent.BLOCK_DEACTIVATE, worldPosition);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        } else {
            self.timeLeft = 0;
        }
        int newComparator = 0;
        if (!stack.isEmpty()) {
            newComparator = 1;
        }
        if (self.burning) {
            newComparator = 2;
        }
        if (self.comparatorOutput != newComparator) {
            self.comparatorOutput = newComparator;
            level.updateNeighbourForOutputSignal(worldPosition, state.getBlock());
        }
    }

    public void spawnSmokeParticles() {
        RandomSource random = this.level.getRandom();
        for (int i = 0; i < 4; ++i) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.05, 0.0);
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.1f, 1.0f);
    }

    public void ignite() {
        ItemStack stack = this.getItemHandler().getItem(0);
        if (stack.isEmpty() || this.burning) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            this.spawnSmokeParticles();
            return;
        }
        this.burning = true;
        Brew brew = ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack);
        this.timeLeft = brew.getPotionEffects(stack).get(0).getDuration() * 60;
        this.level.playSound(null, this.getBlockPos(), BotaniaSounds.incensePlateIgnite, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.level.gameEvent(null, GameEvent.BLOCK_ACTIVATE, this.getBlockPos());
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.putInt(TAG_TIME_LEFT, this.timeLeft);
        tag.putBoolean(TAG_BURNING, this.burning);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.timeLeft = tag.getInt(TAG_TIME_LEFT);
        this.burning = tag.getBoolean(TAG_BURNING);
    }

    public boolean acceptsItem(ItemStack stack) {
        return !stack.isEmpty() && stack.is(BotaniaItems.incenseStick) && ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack) != BotaniaBrews.fallbackBrew;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean canPlaceItem(int index, ItemStack stack) {
                return IncensePlateBlockEntity.this.acceptsItem(stack);
            }
        };
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return false;
    }
}

