/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.BlockProviderHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.RingOfLokiItem;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.xplat.XplatAbstractions;

public class AstrolabeItem
extends Item {
    public static final String TAG_BLOCKSTATE = "blockstate";
    public static final String TAG_SIZE = "size";
    public static final int BASE_COST = 320;

    public AstrolabeItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        Player player = ctx.getPlayer();
        if (player != null && player.isSecondaryUseActive()) {
            if (AstrolabeItem.setBlock(stack, state)) {
                this.displayRemainderCounter(player, stack);
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
            }
        } else if (player != null) {
            boolean did = this.placeAllBlocks(stack, player, ctx.getHand());
            if (did) {
                this.displayRemainderCounter(player, stack);
            }
            return did ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (playerIn.isSecondaryUseActive()) {
            playerIn.playSound(BotaniaSounds.astrolabeConfigure, 1.0f, 1.0f);
            if (!worldIn.isClientSide) {
                int size = AstrolabeItem.getSize(stack);
                int newSize = size == 11 ? 3 : size + 2;
                AstrolabeItem.setSize(stack, newSize);
                ItemsRemainingRenderHandler.send(playerIn, stack, 0, (Component)Component.literal((String)(newSize + "x" + newSize)));
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public boolean placeAllBlocks(ItemStack requester, Player player, InteractionHand hand) {
        Block blockToPlace = AstrolabeItem.getBlock(requester, (HolderGetter<Block>)player.level().holderLookup(Registries.BLOCK));
        int size = AstrolabeItem.getSize(requester);
        BlockPlaceContext ctx = AstrolabeItem.getBlockPlaceContext(player, hand, blockToPlace);
        List<BlockPos> placePositions = AstrolabeItem.getPlacePositions(ctx, size);
        List<BlockProvider> blockProviders = AstrolabeItem.findBlockProviders(requester, player, placePositions.size(), blockToPlace);
        if (ctx == null || blockProviders.isEmpty()) {
            return false;
        }
        int cost = size * 320;
        if (!ManaItemHandler.instance().requestManaExact(requester, player, cost, true)) {
            return false;
        }
        for (BlockPos coords : placePositions) {
            if (!this.placeBlockAndConsume(requester, blockToPlace, ctx, coords, blockProviders)) break;
        }
        return true;
    }

    private boolean placeBlockAndConsume(ItemStack requester, Block blockToPlace, BlockPlaceContext ctx, BlockPos pos, List<BlockProvider> providers) {
        Player player = ctx.getPlayer();
        if (player == null) {
            return false;
        }
        BlockState state = blockToPlace.getStateForPlacement(ctx);
        if (state == null) {
            return true;
        }
        if (providers.stream().noneMatch(prov -> prov.provideBlock(player, requester, blockToPlace, false))) {
            return false;
        }
        UseOnContext useOnContext = RingOfLokiItem.getUseOnContext(player, ctx.getHand(), pos, ctx.getClickLocation(), ctx.getClickedFace());
        if (!PlayerHelper.substituteUse(useOnContext, new ItemStack((ItemLike)blockToPlace)).consumesAction()) {
            return true;
        }
        for (BlockProvider prov2 : providers) {
            if (prov2.provideBlock(player, requester, blockToPlace, true)) break;
        }
        return true;
    }

    public static boolean hasBlocks(ItemStack requester, Player player, int required, Block block) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        return !AstrolabeItem.findBlockProviders(requester, player, required, block).isEmpty();
    }

    public static List<BlockProvider> findBlockProviders(ItemStack requester, Player player, int required, Block block) {
        if (block == Blocks.AIR || required == 0) {
            return List.of();
        }
        if (player.getAbilities().instabuild) {
            return List.of(BlockProviderHelper.asInfiniteBlockProvider(new ItemStack((ItemLike)block)));
        }
        int current = 0;
        ArrayList<BlockProvider> providersToCheck = new ArrayList<BlockProvider>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            int count;
            ItemStack stackInSlot = player.getInventory().getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.is(block.asItem())) {
                current += stackInSlot.getCount();
                BlockProvider stackProvider = BlockProviderHelper.asBlockProvider(stackInSlot);
                providersToCheck.add(stackProvider);
                continue;
            }
            BlockProvider provider = XplatAbstractions.INSTANCE.findBlockProvider(stackInSlot);
            if (provider == null || (count = provider.getBlockCount(player, requester, block)) == 0) continue;
            current += count;
            providersToCheck.add(provider);
        }
        return current >= required ? providersToCheck : List.of();
    }

    @Nullable
    public static BlockPlaceContext getBlockPlaceContext(Player player, InteractionHand hand, Block blockToPlace) {
        if (blockToPlace == Blocks.AIR) {
            return null;
        }
        BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 5.0, true);
        return rtr.getType() == HitResult.Type.BLOCK ? new BlockPlaceContext(player, hand, new ItemStack((ItemLike)blockToPlace.asItem()), rtr) : null;
    }

    public static List<BlockPos> getPlacePositions(BlockPlaceContext ctx, int size) {
        if (ctx == null || ctx.getPlayer() == null) {
            return List.of();
        }
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        BlockPos pos = ctx.getClickedPos();
        BlockState clickedState = ctx.getLevel().getBlockState(pos);
        if (clickedState.canBeReplaced() || clickedState.canBeReplaced(ctx)) {
            pos = pos.relative(ctx.getClickedFace().getOpposite());
        }
        int range = (size ^ 1) / 2;
        Direction dir = ctx.getClickedFace();
        Direction rotationDir = Direction.fromYRot((double)ctx.getPlayer().getYRot());
        boolean pitchedVertically = Math.abs(ctx.getPlayer().getXRot()) > 50.0f;
        boolean axisX = rotationDir.getAxis() == Direction.Axis.X;
        boolean axisZ = rotationDir.getAxis() == Direction.Axis.Z;
        int xOff = axisZ || pitchedVertically ? range : 0;
        int yOff = pitchedVertically ? 0 : range;
        int zOff = axisX || pitchedVertically ? range : 0;
        for (int x = -xOff; x < xOff + 1; ++x) {
            for (int y = 0; y < yOff * 2 + 1; ++y) {
                for (int z = -zOff; z < zOff + 1; ++z) {
                    int xp = pos.getX() + x + dir.getStepX();
                    int yp = pos.getY() + y + dir.getStepY();
                    int zp = pos.getZ() + z + dir.getStepZ();
                    BlockPos newPos = new BlockPos(xp, yp, zp);
                    BlockState state = ctx.getLevel().getBlockState(newPos);
                    if (!ctx.getLevel().getWorldBorder().isWithinBounds(newPos) || !state.isAir() && !state.canBeReplaced() && !state.canBeReplaced(ctx)) continue;
                    coords.add(newPos);
                }
            }
        }
        return coords;
    }

    public void displayRemainderCounter(Player player, ItemStack stack) {
        Block block = AstrolabeItem.getBlock(stack, (HolderGetter<Block>)player.level().holderLookup(Registries.BLOCK));
        int count = ShiftingCrustRodItem.getInventoryItemCount(player, stack, block.asItem());
        if (!player.level().isClientSide) {
            ItemsRemainingRenderHandler.send(player, new ItemStack((ItemLike)block), count);
        }
    }

    public static boolean setBlock(ItemStack stack, BlockState state) {
        if (!state.isAir()) {
            ItemNBTHelper.setCompound(stack, TAG_BLOCKSTATE, NbtUtils.writeBlockState((BlockState)state.getBlock().defaultBlockState()));
            return true;
        }
        return false;
    }

    public static void setSize(ItemStack stack, int size) {
        ItemNBTHelper.setInt(stack, TAG_SIZE, size | 1);
    }

    public static int getSize(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SIZE, 3) | 1;
    }

    public static Block getBlock(ItemStack stack, HolderGetter<Block> holderGetter) {
        return AstrolabeItem.getBlockState(stack, holderGetter).getBlock();
    }

    public static BlockState getBlockState(ItemStack stack, HolderGetter<Block> holderGetter) {
        return NbtUtils.readBlockState(holderGetter, (CompoundTag)ItemNBTHelper.getCompound(stack, TAG_BLOCKSTATE, false));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tip, TooltipFlag flags) {
        if (level == null) {
            return;
        }
        Block block = AstrolabeItem.getBlock(stack, (HolderGetter<Block>)level.holderLookup(Registries.BLOCK));
        int size = AstrolabeItem.getSize(stack);
        tip.add((Component)Component.literal((String)(size + " x " + size)));
        if (block != Blocks.AIR) {
            tip.add((Component)new ItemStack((ItemLike)block).getHoverName().plainCopy().withStyle(ChatFormatting.GRAY));
        }
    }
}

