/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;

public class LensDyeingRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<LensDyeingRecipe> SERIALIZER = new NoOpRecipeSerializer<LensDyeingRecipe>(LensDyeingRecipe::new);
    private final Supplier<List<Ingredient>> dyes = Suppliers.memoize(() -> Arrays.asList(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGENTA_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_BLUE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.YELLOW_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIME_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAY_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.LIGHT_GRAY_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CYAN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GREEN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLACK_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));

    public LensDyeingRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.REDSTONE);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundLens = false;
        boolean foundDye = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BasicLensItem && !foundLens) {
                foundLens = true;
                continue;
            }
            if (!foundDye) {
                int color = this.getStackColor(stack);
                if (color > -1) {
                    foundDye = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundLens && foundDye;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack lens = ItemStack.EMPTY;
        int color = -1;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BasicLensItem && lens.isEmpty()) {
                lens = stack;
                continue;
            }
            color = this.getStackColor(stack);
        }
        if (lens.getItem() instanceof BasicLensItem) {
            ItemStack lensCopy = lens.copyWithCount(1);
            LensItem.setLensColor(lensCopy, color);
            return lensCopy;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    private int getStackColor(ItemStack stack) {
        List<Ingredient> dyes = this.dyes.get();
        for (int i = 0; i < dyes.size(); ++i) {
            if (!dyes.get(i).test(stack)) continue;
            return i;
        }
        return -1;
    }
}

