/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.red_string;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class RedStringInterceptorBlockEntity
extends RedStringBlockEntity {
    private static final Set<RedStringInterceptorBlockEntity> interceptors = new HashSet<RedStringInterceptorBlockEntity>();

    public RedStringInterceptorBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.RED_STRING_INTERCEPTOR, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, RedStringInterceptorBlockEntity self) {
        RedStringBlockEntity.commonTick(level, worldPosition, state, self);
        if (!level.isClientSide) {
            interceptors.add(self);
        }
    }

    @Override
    public boolean acceptBlock(BlockPos pos) {
        return this.level.getBlockEntity(pos) != null;
    }

    private boolean saneState() {
        return !this.isRemoved() && this.level.getBlockEntity(this.worldPosition) == this;
    }

    public static InteractionResult onInteract(Player player, Level world, BlockPos pos, InteractionHand hand) {
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        ArrayList<RedStringInterceptorBlockEntity> remove = new ArrayList<RedStringInterceptorBlockEntity>();
        boolean did = false;
        for (RedStringInterceptorBlockEntity inter : interceptors) {
            BlockPos coords;
            if (!inter.saneState()) {
                remove.add(inter);
                continue;
            }
            if (inter.level != world || (coords = inter.getBinding()) == null || !coords.equals((Object)pos)) continue;
            Block block = inter.getBlockState().getBlock();
            world.setBlockAndUpdate(inter.getBlockPos(), (BlockState)world.getBlockState(inter.getBlockPos()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
            world.scheduleTick(inter.getBlockPos(), block, 2);
            did = true;
        }
        interceptors.removeAll(remove);
        if (did) {
            player.swing(hand);
            world.playSound(null, pos, BotaniaSounds.redStringInterceptorClick, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

