/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AlfheimPortalBreadTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("alf_portal_bread");
    public static final AlfheimPortalBreadTrigger INSTANCE = new AlfheimPortalBreadTrigger();

    private AlfheimPortalBreadTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, ContextAwarePredicate playerPredicate, DeserializationContext conditions) {
        return new Instance(playerPredicate, LocationPredicate.fromJson((JsonElement)json.get("portal_location")));
    }

    public void trigger(ServerPlayer player, BlockPos portal) {
        this.trigger(player, instance -> instance.test(player.serverLevel(), portal));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final LocationPredicate portal;

        public Instance(ContextAwarePredicate playerPredicate, LocationPredicate portal) {
            super(ID, playerPredicate);
            this.portal = portal;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ServerLevel world, BlockPos portal) {
            return this.portal.matches(world, (double)portal.getX(), (double)portal.getY(), (double)portal.getZ());
        }

        public LocationPredicate getPortal() {
            return this.portal;
        }

        public JsonObject serializeToJson(SerializationContext context) {
            JsonObject json = super.serializeToJson(context);
            if (this.portal != LocationPredicate.ANY) {
                json.add("portal_location", this.portal.serializeToJson());
            }
            return json;
        }
    }
}

