/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaSparkEntity
extends SparkBaseEntity
implements ManaSpark {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final EntityDataAccessor<Integer> UPGRADE = SynchedEntityData.defineId(ManaSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final Set<ManaSpark> outgoingTransfers = Collections.newSetFromMap(new WeakHashMap());
    private final ArrayList<ManaSpark> transfersTowardsSelfToRegister = new ArrayList();
    private boolean shouldFilterTransfers = true;
    private boolean receiverWasFull = true;
    private boolean firstTick = true;

    public ManaSparkEntity(EntityType<ManaSparkEntity> type, Level world) {
        super(type, world);
    }

    public ManaSparkEntity(Level world) {
        this(BotaniaEntities.SPARK, world);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(UPGRADE, (Object)0);
    }

    @NotNull
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getSparkItem());
    }

    public void tick() {
        SparkAttachable tile;
        if (this.level().isClientSide) {
            return;
        }
        if (this.firstTick) {
            this.updateTransfers();
        }
        if ((tile = this.getAttachedTile()) == null) {
            this.dropAndKill();
            return;
        }
        ManaReceiver receiver = this.getAttachedManaReceiver();
        SparkUpgradeType upgrade = this.getUpgrade();
        Collection<ManaSpark> transfers = this.getOutgoingTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                Player player2;
                AABB aabb = VecHelper.boxForRange(this.position().with(Direction.Axis.Y, this.getY() + (double)this.getBbHeight() / 2.0), 12.0);
                List players = this.level().getEntitiesOfClass(Player.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
                HashMap receivingPlayers = new HashMap();
                ItemStack input = new ItemStack((ItemLike)this.getSparkItem());
                for (Player player2 : players) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    stacks.addAll((Collection<ItemStack>)player2.getInventory().items);
                    stacks.addAll((Collection<ItemStack>)player2.getInventory().armor);
                    Container inv = BotaniaAPI.instance().getAccessoriesInventory(player2);
                    for (int i = 0; i < inv.getContainerSize(); ++i) {
                        stacks.add(inv.getItem(i));
                    }
                    for (ItemStack stack : stacks) {
                        int recv;
                        HashMap<ManaItem, Integer> receivingStacks;
                        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                        if (stack.isEmpty() || manaItem == null || !manaItem.canReceiveManaFromItem(input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player2)) {
                            add = true;
                            receivingStacks = new HashMap<ManaItem, Integer>();
                        } else {
                            receivingStacks = (HashMap<ManaItem, Integer>)receivingPlayers.get(player2);
                        }
                        if ((recv = Math.min(receiver.getCurrentMana(), Math.min(1000, manaItem.getMaxMana() - manaItem.getMana()))) <= 0) continue;
                        receivingStacks.put(manaItem, recv);
                        if (!add) continue;
                        receivingPlayers.put(player2, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player2 = (Player)keys.iterator().next();
                Map items = (Map)receivingPlayers.get(player2);
                Map.Entry e = items.entrySet().iterator().next();
                ManaItem manaItem = (ManaItem)e.getKey();
                int cost = (Integer)e.getValue();
                int manaToPut = Math.min(receiver.getCurrentMana(), cost);
                manaItem.addMana(manaToPut);
                receiver.receiveMana(-manaToPut);
                this.particlesTowards((Entity)player2);
                break;
            }
            case DOMINANT: {
                if (this.receiverWasFull && !receiver.isFull()) {
                    this.updateTransfers();
                }
                if (this.transfersTowardsSelfToRegister.isEmpty()) break;
                this.transfersTowardsSelfToRegister.remove(this.transfersTowardsSelfToRegister.size() - 1).registerTransfer(this);
                break;
            }
            default: {
                if (!this.receiverWasFull || receiver.isFull()) break;
                this.notifyOthers(this.getNetwork());
            }
        }
        this.receiverWasFull = receiver != null ? receiver.isFull() : true;
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), receiver.getCurrentMana());
            int count = transfers.size();
            int manaSpent = 0;
            if (manaTotal > 0) {
                if (this.shouldFilterTransfers) {
                    this.filterTransfers();
                    this.shouldFilterTransfers = false;
                }
                for (ManaSpark spark : transfers) {
                    --count;
                    SparkAttachable attached = spark.getAttachedTile();
                    ManaReceiver attachedReceiver = spark.getAttachedManaReceiver();
                    if (attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone()) {
                        this.shouldFilterTransfers = true;
                        continue;
                    }
                    int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                    attachedReceiver.receiveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards(spark.entity());
                }
                receiver.receiveMana(-manaSpent);
            }
        }
        this.firstTick = false;
    }

    @Override
    public void updateTransfers() {
        this.transfersTowardsSelfToRegister.clear();
        switch (this.getUpgrade()) {
            case RECESSIVE: {
                List<ManaSpark> otherSparks = SparkHelper.getSparksAround(this.level(), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), this.getNetwork());
                Collections.shuffle(otherSparks);
                for (ManaSpark otherSpark : otherSparks) {
                    SparkUpgradeType otherUpgrade = otherSpark.getUpgrade();
                    if (otherSpark == this || otherUpgrade == SparkUpgradeType.DOMINANT || otherUpgrade == SparkUpgradeType.RECESSIVE || otherUpgrade == SparkUpgradeType.ISOLATED) continue;
                    this.outgoingTransfers.add(otherSpark);
                }
                break;
            }
            case DOMINANT: {
                List<ManaSpark> validSparks = SparkHelper.getSparksAround(this.level(), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), this.getNetwork());
                for (ManaSpark spark : validSparks) {
                    SparkUpgradeType otherUpgrade = spark.getUpgrade();
                    if (spark == this || otherUpgrade != SparkUpgradeType.NONE || !(spark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                    this.transfersTowardsSelfToRegister.add(spark);
                }
                Collections.shuffle(this.transfersTowardsSelfToRegister);
            }
        }
        this.filterTransfers();
    }

    private void particlesTowards(Entity e) {
        XplatAbstractions.INSTANCE.sendToTracking(this, new BotaniaEffectPacket(EffectType.SPARK_MANA_FLOW, this.getX(), this.getY(), this.getZ(), this.getId(), e.getId(), ColorHelper.getColorValue(this.getNetwork())));
    }

    public static void particleBeam(Player player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.level().isClientSide) {
            XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.SPARK_NET_INDICATOR, e1.getX(), e1.getY(), e1.getZ(), e1.getId(), e2.getId()));
        }
    }

    protected Item getSparkItem() {
        return BotaniaItems.spark;
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.spawnAtLocation(new ItemStack((ItemLike)this.getSparkItem()), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.spawnAtLocation(SparkAugmentItem.getByType(upgrade), 0.0f);
        }
        this.discard();
    }

    public void remove(Entity.RemovalReason removalReason) {
        super.remove(removalReason);
        this.notifyOthers(this.getNetwork());
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isAlive() && !stack.isEmpty()) {
            DyeItem dye;
            DyeColor color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.getItem() instanceof WandOfTheForestItem) {
                if (!this.level().isClientSide) {
                    if (player.isShiftKeyDown()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.spawnAtLocation(SparkAugmentItem.getByType(upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.outgoingTransfers.clear();
                            this.notifyOthers(this.getNetwork());
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround(this.level(), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), this.getNetwork()).forEach(s -> ManaSparkEntity.particleBeam(player, this, s.entity()));
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            Item item = stack.getItem();
            if (item instanceof SparkAugmentItem) {
                SparkAugmentItem newUpgrade = (SparkAugmentItem)item;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.level().isClientSide) {
                        this.setUpgrade(newUpgrade.type);
                        stack.shrink(1);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            if (stack.is(BotaniaItems.phantomInk)) {
                if (!this.level().isClientSide) {
                    this.setInvisible(true);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            item = stack.getItem();
            if (item instanceof DyeItem && (color = (dye = (DyeItem)item).getDyeColor()) != this.getNetwork()) {
                if (!this.level().isClientSide) {
                    this.setNetwork(color);
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.getInt(TAG_UPGRADE)]);
    }

    @Override
    protected void addAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putInt(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Override
    public SparkAttachable getAttachedTile() {
        return XplatAbstractions.INSTANCE.findSparkAttachable(this.level(), this.getAttachPos(), this.level().getBlockState(this.getAttachPos()), this.level().getBlockEntity(this.getAttachPos()), Direction.UP);
    }

    @Override
    @Nullable
    public ManaReceiver getAttachedManaReceiver() {
        return XplatAbstractions.INSTANCE.findManaReceiver(this.level(), this.getAttachPos(), Direction.UP);
    }

    private void filterTransfers() {
        Iterator<ManaSpark> iter = this.outgoingTransfers.iterator();
        while (iter.hasNext()) {
            ManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ManaReceiver arecv = spark.getAttachedManaReceiver();
            if (spark != this && ((Entity)spark).isAlive() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && arecv != null && !arecv.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(arecv instanceof ManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<ManaSpark> getOutgoingTransfers() {
        return this.outgoingTransfers;
    }

    private boolean hasTransfer(ManaSpark entity) {
        return this.outgoingTransfers.contains(entity);
    }

    @Override
    public void registerTransfer(ManaSpark entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.outgoingTransfers.add(entity);
        this.filterTransfers();
    }

    private void notifyOthers(DyeColor network) {
        for (ManaSpark spark : SparkHelper.getSparksAround(this.level(), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), network)) {
            spark.updateTransfers();
        }
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.entityData.get(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.entityData.set(UPGRADE, (Object)upgrade.ordinal());
        this.updateTransfers();
        this.notifyOthers(this.getNetwork());
    }

    @Override
    public void setNetwork(DyeColor color) {
        DyeColor previousNetwork = this.getNetwork();
        super.setNetwork(color);
        this.updateTransfers();
        this.notifyOthers(color);
        this.notifyOthers(previousNetwork);
    }

    @Override
    public boolean areIncomingTransfersDone() {
        if (this.getAttachedManaReceiver() instanceof ManaPool) {
            return false;
        }
        SparkAttachable attachable = this.getAttachedTile();
        return attachable != null && attachable.areIncomingTranfersDone();
    }

    public record WandHud(ManaSparkEntity entity) implements WandHUD
    {
        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack sparkStack = new ItemStack((ItemLike)this.entity.getSparkItem());
            ItemStack augmentStack = SparkAugmentItem.getByType(this.entity.getUpgrade());
            DyeColor networkColor = this.entity.getNetwork();
            MutableComponent networkColorName = Component.translatable((String)("color.minecraft." + networkColor.getName())).withStyle(ChatFormatting.ITALIC);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);
            int width = 4 + Collections.max(Arrays.asList(mc.font.width((FormattedText)networkColorName), RenderHelper.itemWithNameWidth(mc, sparkStack), RenderHelper.itemWithNameWidth(mc, augmentStack)));
            int height = augmentStack.isEmpty() ? 30 : 50;
            int networkColorTextStart = mc.font.width((FormattedText)networkColorName) / 2;
            int centerX = mc.getWindow().getGuiScaledWidth() / 2;
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 8 + height);
            RenderHelper.renderItemWithNameCentered(gui, mc, sparkStack, centerY + 10, textColor);
            RenderHelper.renderItemWithNameCentered(gui, mc, augmentStack, centerY + 28, textColor);
            gui.drawString(mc.font, (Component)networkColorName, centerX - networkColorTextStart, centerY + (augmentStack.isEmpty() ? 28 : 46), textColor);
        }
    }
}

