/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import vazkii.botania.common.block.BotaniaBlocks;

import java.util.function.Consumer;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2444;
import net.minecraft.class_2454;
import net.minecraft.class_7784;
import net.minecraft.class_7800;

public class SmeltingProvider extends BotaniaRecipeProvider {
	public SmeltingProvider(class_7784 packOutput) {
		super(packOutput);
	}

	private static class_2066.class_2068 conditionsFromItem(class_1935 item) {
		return CraftingRecipeProvider.conditionsFromItem(item);
	}

	@Override
	public void buildRecipes(Consumer<class_2444> consumer) {
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneForest),
				class_7800.field_40634, BotaniaBlocks.biomeStoneForest, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneForest))
				.method_36443(consumer, "botania:smelting/metamorphic_forest_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestonePlains),
				class_7800.field_40634, BotaniaBlocks.biomeStonePlains, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestonePlains))
				.method_36443(consumer, "botania:smelting/metamorphic_plains_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneMountain),
				class_7800.field_40634, BotaniaBlocks.biomeStoneMountain, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneMountain))
				.method_36443(consumer, "botania:smelting/metamorphic_mountain_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneFungal),
				class_7800.field_40634, BotaniaBlocks.biomeStoneFungal, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneFungal))
				.method_36443(consumer, "botania:smelting/metamorphic_fungal_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneSwamp),
				class_7800.field_40634, BotaniaBlocks.biomeStoneSwamp, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneSwamp))
				.method_36443(consumer, "botania:smelting/metamorphic_swamp_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneDesert),
				class_7800.field_40634, BotaniaBlocks.biomeStoneDesert, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneDesert))
				.method_36443(consumer, "botania:smelting/metamorphic_desert_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneTaiga),
				class_7800.field_40634, BotaniaBlocks.biomeStoneTaiga, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneTaiga))
				.method_36443(consumer, "botania:smelting/metamorphic_taiga_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.biomeCobblestoneMesa),
				class_7800.field_40634, BotaniaBlocks.biomeStoneMesa, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.biomeCobblestoneMesa))
				.method_36443(consumer, "botania:smelting/metamorphic_mesa_stone");
		class_2454.method_17802(class_1856.method_8091(BotaniaBlocks.livingrockBrick),
				class_7800.field_40634, BotaniaBlocks.livingrockBrickCracked, 0.1f, 200)
				.method_10469("has_item", conditionsFromItem(BotaniaBlocks.livingrockBrick))
				.method_36443(consumer, "botania:smelting/cracked_livingrock_bricks");
	}

	@Override
	public String method_10321() {
		return "Botania smelting recipes";
	}
}
