/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class FloralFertilizerItem extends class_1792 {
	private static final int RANGE = 3;

	public FloralFertilizerItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		if (!world.field_9236) {
			Optional<class_6885.class_6888<class_2248>> flowersTag =
					class_7923.field_41175.method_40266(BotaniaTags.Blocks.MYSTICAL_FLOWERS);
			Optional<class_6885.class_6888<class_2248>> mushroomsTag =
					class_7923.field_41175.method_40266(BotaniaTags.Blocks.SHIMMERING_MUSHROOMS);
			boolean flowersAvailable = flowersTag.map(holders -> holders.method_40247() > 0).orElse(false);
			boolean mushroomsAvailable = mushroomsTag.map(holders -> holders.method_40247() > 0).orElse(false);

			List<class_2338> validCoords = new ArrayList<>();

			for (class_2338 candidatePos : class_2338.method_10094(
					pos.method_10263() - RANGE, pos.method_10264() - 2, pos.method_10260() - RANGE,
					pos.method_10263() + RANGE, pos.method_10264() + 2, pos.method_10260() + RANGE)) {
				if (!world.method_24794(candidatePos) || !world.method_22347(candidatePos)) {
					continue;
				}
				class_2680 belowState = world.method_8320(candidatePos.method_10074());
				if (flowersAvailable && canPlaceFlower(belowState, world) || mushroomsAvailable && canPlaceMushroom(belowState)) {
					validCoords.add(candidatePos.method_10062());
				}
			}

			int petalCount = world.field_9229.method_39332(5, 7);
			while (petalCount > 0 && !validCoords.isEmpty()) {
				petalCount--;
				class_2338 coords = validCoords.get(world.field_9229.method_43048(validCoords.size()));
				validCoords.remove(coords);
				class_2680 belowState = world.method_8320(coords.method_10074());
				boolean tryPlaceFlower = flowersAvailable && canPlaceFlower(belowState, world);
				boolean tryPlaceMushroom = mushroomsAvailable && canPlaceMushroom(belowState);

				Optional<class_6880<class_2248>> toPlace;
				if (tryPlaceMushroom && (!tryPlaceFlower || world.field_9229.method_43048(3) == 0)) {
					toPlace = mushroomsTag.get().method_40243(world.field_9229);
				} else if (tryPlaceFlower) {
					toPlace = flowersTag.get().method_40243(world.field_9229);
					petalCount--;
				} else {
					continue;
				}

				if (toPlace.isPresent() && !toPlace.get().comp_349().method_9564().method_26215()) {
					world.method_8501(coords, toPlace.get().comp_349().method_9564());
				}
			}
			ctx.method_8041().method_7934(1);
		} else {
			for (int i = 0; i < 15; i++) {
				double x = pos.method_10263() - RANGE + world.field_9229.method_43048(RANGE * 2 + 1) + Math.random();
				double y = pos.method_10264() + 1;
				double z = pos.method_10260() - RANGE + world.field_9229.method_43048(RANGE * 2 + 1) + Math.random();
				float red = (float) Math.random();
				float green = (float) Math.random();
				float blue = (float) Math.random();
				WispParticleData data = WispParticleData.wisp(0.15F + (float) Math.random() * 0.25F, red, green, blue, 1);
				world.method_8406(data, x, y, z, 0, (float) Math.random() * 0.1F - 0.05F, 0);
			}
		}

		return class_1269.method_29236(world.method_8608());
	}

	private static boolean canPlaceMushroom(class_2680 belowState) {
		return belowState.method_26164(class_3481.field_25739);
	}

	private static boolean canPlaceFlower(class_2680 belowState, class_1937 world) {
		return belowState.method_26164(class_3481.field_29822) && !world.method_8597().comp_644();
	}
}
