package vazkii.botania.api.configdata;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public class LooniumMobEffectToApply {
	public static final Codec<LooniumMobEffectToApply> CODEC = RecordCodecBuilder.create(
			instance -> instance.group(
					class_7923.field_41174.method_39673().fieldOf("effect").forGetter(me -> me.effect),
					class_5699.field_33442.optionalFieldOf("duration", class_1293.field_42106)
							.forGetter(me -> me.duration),
					Codec.intRange(0, 255).optionalFieldOf("amplifier", 0)
							.forGetter(me -> me.amplifier)
			).apply(instance, LooniumMobEffectToApply::new)
	);

	private final class_1291 effect;
	private final int duration;
	private final int amplifier;

	private LooniumMobEffectToApply(class_1291 effect, int duration, int amplifier) {
		this.effect = effect;
		this.duration = duration;
		this.amplifier = amplifier;
	}

	public static Builder effect(class_1291 effect) {
		return new Builder(effect);
	}

	@NotNull
	public class_1293 createMobEffectInstance() {
		return new class_1293(effect, duration, amplifier);
	}

	@Override
	public String toString() {
		return "MobEffectToApply{" +
				"effect=" + effect +
				", duration=" + duration +
				", amplifier=" + amplifier +
				'}';
	}

	public class_1291 getEffect() {
		return effect;
	}

	public int getDuration() {
		return duration;
	}

	public int getAmplifier() {
		return amplifier;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		return obj instanceof LooniumMobEffectToApply that && Objects.equals(this.effect, that.effect)
				&& this.duration == that.duration && this.amplifier == that.amplifier;
	}

	@Override
	public int hashCode() {
		return Objects.hash(effect, duration, amplifier);
	}

	public static class Builder {
		private final class_1291 effect;
		private int duration = class_1293.field_42106;
		private int amplifier = 0;

		private Builder(class_1291 effect) {
			this.effect = effect;
		}

		public Builder duration(int duration) {
			this.duration = duration;
			return this;
		}

		public Builder amplifier(int amplifier) {
			this.amplifier = amplifier;
			return this;
		}

		public LooniumMobEffectToApply build() {
			return new LooniumMobEffectToApply(effect, duration, amplifier);
		}
	}
}
