/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2462;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_572;
import net.minecraft.class_811;
import net.minecraft.world.item.*;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.integration.shared.LocaleHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;

import java.util.List;

public class ManaseerMonocleItem extends BaubleItem implements CosmeticBauble {

	public ManaseerMonocleItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		tooltip.add(class_2561.method_43471("botaniamisc.cosmeticBauble").method_27695(class_124.field_1056, class_124.field_1080));
		super.method_7851(stack, world, tooltip, flags);
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			bipedModel.field_3398.method_22703(ms);
			ms.method_22904(0.15, -0.2, -0.25);
			ms.method_22905(0.3F, -0.3F, -0.3F);
			class_310.method_1551().method_1480().method_23178(stack, class_811.field_4315,
					light, class_4608.field_21444, ms, buffers, living.method_37908(), living.method_5628());
		}
	}

	public static class Hud {
		private static final int MAX_CONTENTS_COLUMNS = 9;
		private static final int MAX_CONTENTS_ROWS = 3;
		public static final int TEXT_ROW_HEIGHT = 12;

		public static void render(class_332 gui, class_1657 player) {
			class_310 mc = class_310.method_1551();
			class_239 hitResult = mc.field_1765;
			if (hitResult instanceof class_3965 bhr && bhr.method_17783() == class_239.class_240.field_1332) {
				renderBlockInfo(gui, bhr, mc, player.method_37908());
			} else if (hitResult instanceof class_3966 ehr && ehr.method_17783() == class_239.class_240.field_1331) {
				renderEntityInfo(gui, ehr, mc);
			}
		}

		private static void renderEntityInfo(class_332 gui, class_3966 hitResult, class_310 mc) {
			class_1297 entity = hitResult.method_17782();

			if (entity instanceof class_1533 frame && !frame.method_6940().method_7960()) {
				class_1799 frameItem = frame.method_6940();
				List<class_1799> contentItems = FilterHelper.getFilterStacks(frameItem);
				if (contentItems.isEmpty() || contentItems.size() == 1 && class_1799.method_31577(frameItem, contentItems.get(0))) {
					return;
				}

				int x = mc.method_22683().method_4486() / 2 + 15;
				int y = mc.method_22683().method_4502() / 2 - 24;
				int maxWidth = mc.method_22683().method_4486() - x - 30;

				class_5250 itemName = class_2561.method_43473().method_10852(frameItem.method_7964())
						.method_27692(frameItem.method_7932().field_8908);
				if (frameItem.method_7938()) {
					itemName.method_27692(class_124.field_1056);
				}
				class_5250 text = class_2561.method_43469("botaniamisc.monocle.frame.contains", itemName);

				List<class_5481> lines = mc.field_1772.method_1728(text, maxWidth);
				int textWidth = lines.stream().mapToInt(mc.field_1772::method_30880).max().orElseThrow();
				int textYOffset = (lines.size() - 1) * TEXT_ROW_HEIGHT;

				int contentsWidth = Math.min(MAX_CONTENTS_COLUMNS, contentItems.size()) * 18;
				int contentsHeight = Math.min(MAX_CONTENTS_ROWS + 1,
						(contentItems.size() - 1) / MAX_CONTENTS_COLUMNS + 1) * 18;
				RenderHelper.renderHUDBox(gui, x - 4, y - 4,
						x + Math.max(textWidth, contentsWidth) + 24, y + textYOffset + contentsHeight + 20);
				gui.method_51427(frameItem, x, y);

				int textRow = 0;
				for (var line : lines) {
					gui.method_35720(mc.field_1772, line, x + 20, y + TEXT_ROW_HEIGHT * textRow + 4, 0xFFFFFF);
					textRow++;
				}

				int row = 1;
				int column = 0;
				for (class_1799 contentItem : contentItems) {
					if (++column > MAX_CONTENTS_COLUMNS) {
						column = 1;
						if (++row > MAX_CONTENTS_ROWS) {
							break;
						}
					}

					gui.method_51427(contentItem, x + 18 * column, y + 18 * row + textYOffset);
					gui.method_51431(mc.field_1772, contentItem, x + 18 * column, y + 18 * row + textYOffset);
				}

				if (row > MAX_CONTENTS_ROWS) {
					class_5250 remainingItemsHint = class_2561.method_43469(
							"botaniamisc.monocle.frame.additional_stacks",
							contentItems.size() - MAX_CONTENTS_COLUMNS * MAX_CONTENTS_ROWS);
					gui.method_27535(mc.field_1772, remainingItemsHint, x + 24, y + 18 * row + 6 + textYOffset, 0xFFFFFF);
				}
			}
		}

		private static void renderBlockInfo(class_332 gui, class_3965 hitResult, class_310 mc, class_1937 level) {
			class_2338 pos = hitResult.method_17777();
			class_2680 state = level.method_8320(pos);

			class_1799 dispStack;
			class_5250 text;

			if (state.method_28498(class_2741.field_12511)) {
				// redstone wire, sculk sensors, daylight detector, target block, weighted pressure plates
				dispStack = new class_1799(state.method_26204());
				text = class_2561.method_43470(state.method_11654(class_2741.field_12511).toString())
						.method_27692(class_124.field_1061);
			} else if (state.method_27852(class_2246.field_10450)) {
				dispStack = new class_1799(class_2246.field_10450);
				text = class_2561.method_43469("botaniamisc.monocle.repeater.delay",
						LocaleHelper.formatAsDecimalFraction(0.1f * state.method_11654(class_2462.field_11451), 1));
			} else if (state.method_27852(class_2246.field_10377)) {
				dispStack = new class_1799(class_2246.field_10377);
				text = class_2561.method_43471("botaniamisc.monocle.comparator."
						+ state.method_11654(class_2286.field_10789).method_15434());
			} else {
				return;
			}

			int x = mc.method_22683().method_4486() / 2 + 15;
			int y = mc.method_22683().method_4502() / 2 - 8;

			int textWidth = mc.field_1772.method_30880(text.method_30937());
			RenderHelper.renderHUDBox(gui, x - 4, y - 4, x + textWidth + 24, y + 20);
			gui.method_51427(dispStack, x, y);
			gui.method_27535(mc.field_1772, text, x + 20, y + 4, 0xFFFFFF);
		}

	}

	public static boolean hasMonocle(class_1309 living) {
		return !EquipmentHandler.findOrEmpty(stack -> {
			if (!stack.method_7960()) {
				class_1792 item = stack.method_7909();
				if (stack.method_31573(BotaniaTags.Items.BURST_VIEWERS)) {
					return true;
				}
				if (item instanceof CosmeticAttachable attach) {
					class_1799 cosmetic = attach.getCosmeticItem(stack);
					return !cosmetic.method_7960() && cosmetic.method_31573(BotaniaTags.Items.BURST_VIEWERS);
				}
			}
			return false;
		}, living).method_7960();
	}

}
