/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.proxy.Proxy;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_811;

public class CosmeticBaubleItem extends BaubleItem implements CosmeticBauble {

	public enum Variant {
		BLACK_BOWTIE, BLACK_TIE, RED_GLASSES(true), PUFFY_SCARF,
		ENGINEER_GOGGLES(true), EYEPATCH(true), WICKED_EYEPATCH(true), RED_RIBBONS(true),
		PINK_FLOWER_BUD(true), POLKA_DOTTED_BOWS(true), BLUE_BUTTERFLY(true), CAT_EARS(true),
		WITCH_PIN, DEVIL_TAIL, KAMUI_EYE, GOOGLY_EYES(true),
		FOUR_LEAF_CLOVER, CLOCK_EYE(true), UNICORN_HORN(true), DEVIL_HORNS(true),
		HYPER_PLUS(true), BOTANIST_EMBLEM, ANCIENT_MASK(true), EERIE_MASK(true),
		ALIEN_ANTENNA(true), ANAGLYPH_GLASSES(true), ORANGE_SHADES(true), GROUCHO_GLASSES(true),
		THICK_EYEBROWS(true), LUSITANIC_SHIELD, TINY_POTATO_MASK(true), QUESTGIVER_MARK(true),
		THINKING_HAND(true);

		private final boolean isHead;

		Variant(boolean isHead) {
			this.isHead = isHead;
		}

		Variant() {
			this(false);
		}
	}

	private final Variant variant;

	public CosmeticBaubleItem(Variant variant, class_1793 props) {
		super(props);
		this.variant = variant;
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		if (variant == Variant.THINKING_HAND) {
			tooltip.add(class_2561.method_43471("botaniamisc.cosmeticThinking").method_27695(class_124.field_1056, class_124.field_1080));
		} else {
			tooltip.add(class_2561.method_43471("botaniamisc.cosmeticBauble").method_27695(class_124.field_1056, class_124.field_1080));
		}
		super.method_7851(stack, world, tooltip, flags);
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			Variant variant = ((CosmeticBaubleItem) stack.method_7909()).variant;
			if (variant.isHead) {
				bipedModel.field_3398.method_22703(ms);
				switch (variant) {
					case RED_GLASSES, ENGINEER_GOGGLES, ANAGLYPH_GLASSES -> {
						ms.method_22904(0, -0.225, -0.3);
						ms.method_22905(0.7F, -0.7F, -0.7F);
						renderItem(stack, ms, buffers, light);
					}
					case EYEPATCH -> {
						ms.method_22904(0.125, -0.225, -0.3);
						ms.method_22907(VecHelper.rotateY(180F));
						ms.method_22905(0.3F, -0.3F, -0.3F);
						renderItem(stack, ms, buffers, light);
					}
					case WICKED_EYEPATCH -> {
						ms.method_22904(-0.125, -0.225, -0.3);
						ms.method_22905(0.3F, -0.3F, -0.3F);
						renderItem(stack, ms, buffers, light);
					}
					case RED_RIBBONS -> {
						ms.method_22904(0, -0.65, 0.2);
						ms.method_22907(VecHelper.rotateY(180F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case PINK_FLOWER_BUD -> {
						ms.method_22904(0.275, -0.6, 0);
						ms.method_22907(VecHelper.rotateY(-90F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case POLKA_DOTTED_BOWS -> {
						ms.method_22903();
						ms.method_22904(0.275, -0.4, 0);
						ms.method_22907(VecHelper.rotateY(-90F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
						ms.method_22909();
						ms.method_22904(-0.275, -0.4, 0);
						ms.method_22907(VecHelper.rotateY(90F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case BLUE_BUTTERFLY -> {
						ms.method_22903();
						ms.method_22904(0.275, -0.4, 0);
						ms.method_22907(VecHelper.rotateY(45F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
						ms.method_22909();
						ms.method_22904(0.275, -0.4, 0);
						ms.method_22907(VecHelper.rotateY(-45F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case CAT_EARS -> {
						ms.method_46416(0F, -0.5F, -0.175F);
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case GOOGLY_EYES -> {
						ms.method_22904(0, -0.225, -0.3);
						ms.method_22905(0.9F, -0.9F, -0.9F);
						renderItem(stack, ms, buffers, light);
					}
					case CLOCK_EYE -> {
						ms.method_22904(0.1, -0.225, -0.3F);
						ms.method_22905(0.4F, -0.4F, -0.4F);
						renderItem(stack, ms, buffers, light);
					}
					case UNICORN_HORN -> {
						ms.method_22904(0, -0.7, -0.3);
						ms.method_22907(VecHelper.rotateY(-90F));
						ms.method_22905(0.6F, -0.6F, -0.6F);
						renderItem(stack, ms, buffers, light);
					}
					case DEVIL_HORNS -> {
						ms.method_46416(0F, -0.4F, -0.175F);
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case HYPER_PLUS -> {
						ms.method_46416(-0.15F, -0.45F, -0.3F);
						ms.method_22905(0.2F, -0.2F, -0.2F);
						renderItem(stack, ms, buffers, light);
						ms.method_46416(1.45F, 0F, 0F);
						renderItem(stack, ms, buffers, light);
					}
					case ANCIENT_MASK -> {
						ms.method_22904(0, -0.3, -0.3);
						ms.method_22905(0.7F, -0.7F, -0.7F);
						renderItem(stack, ms, buffers, light);
					}
					case EERIE_MASK -> {
						ms.method_22904(0, -0.25, -0.3);
						ms.method_22905(0.75F, -0.75F, -0.75F);
						renderItem(stack, ms, buffers, light);
					}
					case ALIEN_ANTENNA -> {
						ms.method_22904(0, -0.65, 0.2);
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case ORANGE_SHADES -> {
						ms.method_22904(0, -0.3, -0.3);
						ms.method_22905(0.7F, -0.7F, -0.7F);
						int color = 0xFFFFFF | (178 << 24);
						RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, light, class_4608.field_21444);
					}
					case GROUCHO_GLASSES -> {
						ms.method_22904(0, -0.1, -0.3);
						ms.method_22905(0.75F, -0.75F, -0.75F);
						renderItem(stack, ms, buffers, light);
					}
					case THICK_EYEBROWS -> {
						ms.method_22903();
						ms.method_22904(-0.1, -0.3, -0.3);
						ms.method_22905(0.3F, -0.3F, -0.3F);
						renderItem(stack, ms, buffers, light);
						ms.method_22909();
						ms.method_22904(0.1, -0.3, -0.3);
						ms.method_22907(VecHelper.rotateY(180F));
						ms.method_22905(0.3F, -0.3F, -0.3F);
						renderItem(stack, ms, buffers, light);
					}
					case TINY_POTATO_MASK -> {
						ms.method_22904(0, -0.3, -0.3);
						ms.method_22905(0.6F, -0.6F, -0.6F);
						renderItem(stack, ms, buffers, light);
					}
					case QUESTGIVER_MARK -> {
						ms.method_22904(0, -0.8, -0.2);
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case THINKING_HAND -> {
						ms.method_22904(-0.1, 0, -0.3);
						ms.method_22907(VecHelper.rotateZ(-15F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					default -> {}
				}
			} else { // body cosmetics
				bipedModel.field_3391.method_22703(ms);
				switch (variant) {
					case BLACK_BOWTIE -> {
						ms.method_22904(0, 0.1, -0.13);
						ms.method_22905(0.6F, -0.6F, -0.6F);
						renderItem(stack, ms, buffers, light);
					}
					case BLACK_TIE, PUFFY_SCARF -> {
						ms.method_22904(0, 0.25, -0.15);
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
					}
					case WITCH_PIN -> {
						ms.method_22904(-0.1, 0.15, -0.15);
						ms.method_22905(0.2F, -0.2F, -0.2F);
						renderItem(stack, ms, buffers, light);
					}
					case DEVIL_TAIL -> {
						ms.method_22904(0, 0.55, 0.2);
						ms.method_22907(VecHelper.rotateY(-90F));
						ms.method_22905(0.6F, -0.6F, -0.6F);
						renderItem(stack, ms, buffers, light);
					}
					case KAMUI_EYE -> { // DON'T LOSE YOUR WAAAAAAAAY
						ms.method_22903();
						ms.method_22904(0.4, 0.1, -0.2);
						ms.method_22905(0.5F, -0.5F, -0.5F);
						renderItem(stack, ms, buffers, light);
						ms.method_22909();
						ms.method_22904(-0.4, 0.1, -0.2);
						ms.method_22907(VecHelper.rotateY(180F));
						ms.method_22905(0.5F, -0.5F, -0.5F);
						RenderHelper.renderItemCustomColor(living, stack, 0xFF00004C, ms, buffers, light, class_4608.field_21444);
					}
					case FOUR_LEAF_CLOVER -> {
						ms.method_22904(0.1, 0.1, -0.13);
						ms.method_22905(0.3F, -0.3F, -0.3F);
						renderItem(stack, ms, buffers, light);
					}
					case BOTANIST_EMBLEM -> {
						ms.method_22904(0F, 0.375, -0.13);
						ms.method_22905(0.3F, -0.3F, -0.3F);
						renderItem(stack, ms, buffers, light);
					}
					case LUSITANIC_SHIELD -> {
						ms.method_22904(0F, 0.35, 0.13);
						ms.method_22907(VecHelper.rotateZ(8F));
						ms.method_22907(VecHelper.rotateY(180F));
						ms.method_22905(0.6F, -0.6F, -0.6F);
						renderItem(stack, ms, buffers, light);
					}
					default -> {}
				}
			}
		}

		private static void renderItem(class_1799 stack, class_4587 ms, class_4597 buffers, int light) {
			class_310.method_1551().method_1480().method_23178(stack, class_811.field_4315,
					light, class_4608.field_21444, ms, buffers, class_310.method_1551().field_1687, 0);
		}
	}

}
