package vazkii.botania.fabric.data;

import vazkii.botania.common.lib.LibMisc;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_173;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public class FabricBlockLootProvider implements class_2405 {
	private final class_7784.class_7489 pathProvider;

	public FabricBlockLootProvider(class_7784 packOutput) {
		this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables/blocks");
	}

	@Override
	public CompletableFuture<?> method_10319(class_7403 cache) {
		var tables = new HashMap<class_2960, class_52.class_53>();
		for (var b : class_7923.field_41175) {
			class_2960 id = class_7923.field_41175.method_10221(b);
			if (!LibMisc.MOD_ID.equals(id.method_12836())) {
				continue;
			}

			// Nothing for now
		}

		List<CompletableFuture<?>> output = new ArrayList<>();

		for (var e : tables.entrySet()) {
			Path path = pathProvider.method_44107(e.getKey());
			output.add(class_2405.method_10320(cache, class_5270.method_27862().create().toJsonTree(e.getValue().method_334(class_173.field_1172).method_338()), path));
		}
		return CompletableFuture.allOf(output.toArray(CompletableFuture[]::new));
	}

	@Override
	public String method_10321() {
		return "Botania block loot (Fabric-specific)";
	}
}
