/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.ItemNBTHelper;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3612;

public class BottledManaItem extends class_1792 {
	public static final int SWIGS = 6;
	private static final String TAG_SWIGS_LEFT = "swigsLeft";
	private static final String TAG_SEED = "randomSeed";

	private static final EffectAction[] EFFECT_ACTIONS = {
			BottledManaItem::effectRandomMotion,
			BottledManaItem::effectWater,
			BottledManaItem::effectSetOnFire,
			BottledManaItem::effectMiniExplosion,
			BottledManaItem::effectMegaJump,
			BottledManaItem::effectSetRandomHp,
			BottledManaItem::effectLotsOfHearts,
			BottledManaItem::effectDropAllItems,
			BottledManaItem::effectBreakNeck,
			BottledManaItem::effectHighestPossible,
			BottledManaItem::effectHyperspeed,
			BottledManaItem::effectNightVision,
			BottledManaItem::effectPixieFriend,
			BottledManaItem::effectNauseaBlindness,
			BottledManaItem::effectDropOwnHead
	};

	public BottledManaItem(class_1793 props) {
		super(props);
	}

	private static void effectRandomMotion(class_1937 level, class_1309 living) {
		living.method_18800((Math.random() - 0.5) * 3, living.method_18798().method_10214(),
				(Math.random() - 0.5) * 3);
	}

	private static void effectWater(class_1937 level, class_1309 living) {
		if (!level.field_9236 && !level.method_8597().comp_644()) {
			class_2338 playerPos = living.method_24515();
			class_2680 state = level.method_8320(playerPos);
			class_2680 replacedState;
			class_2338 waterPos;
			// loosely based on BucketItem#emptyContent:
			if (state.method_26215() || state.method_26188(class_3612.field_15910)
					|| state.method_26204() instanceof class_2402 lbc
							&& lbc.method_10310(level, playerPos, state, class_3612.field_15910)) {
				waterPos = playerPos;
				replacedState = state;
			} else {
				class_2680 aboveState = level.method_8320(playerPos.method_10084());
				waterPos = (aboveState.method_26215() || aboveState.method_26188(class_3612.field_15910)
						|| aboveState.method_26204() instanceof class_2402 lbc
								&& lbc.method_10310(level, playerPos.method_10084(), aboveState, class_3612.field_15910))
										? playerPos.method_10084()
										: null;
				replacedState = aboveState;
			}
			if (waterPos != null) {
				boolean placed;
				if (replacedState.method_26204() instanceof class_2402 lbc) {
					placed = lbc.method_10311(level, waterPos, replacedState, class_3612.field_15910.method_15729(false));
				} else {
					if (replacedState.method_26188(class_3612.field_15910)) {
						level.method_22352(waterPos, true);
					}
					placed = level.method_8501(waterPos, class_2246.field_10382.method_9564());
				}
				if (placed) {
					level.method_45445(living, waterPos, class_3417.field_15237, class_3419.field_15245, 1.0f, level.field_9229.method_43057() + 0.5f);
				}
			}
		}
	}

	private static void effectSetOnFire(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			living.method_5639(4);
		}
	}

	private static void effectMiniExplosion(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			level.method_8437(null, living.method_23317(), living.method_23318(),
					living.method_23321(), 0.25F, class_1937.class_7867.field_40888);
		}
	}

	private static void effectMegaJump(class_1937 level, class_1309 living) {
		if (!level.method_8597().comp_644()) {
			if (!level.field_9236) {
				living.method_6092(new class_1293(class_1294.field_5907, 300, 5));
			}
			living.method_18800(living.method_18798().method_10216(), 6, living.method_18798().method_10215());
		}
	}

	private static void effectSetRandomHp(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			float nextHealth = (float) (Math.random() * living.method_6063());
			if (class_3532.method_15347(nextHealth, 0.0F)) {
				nextHealth = 0.5F;
			}
			living.method_6033(nextHealth);
		}
	}

	private static void effectLotsOfHearts(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			living.method_6092(new class_1293(class_1294.field_5898, 20 * 60 * 2, 9));
		}
	}

	private static void effectBreakNeck(class_1937 level, class_1309 living) {
		living.method_36457((float) Math.random() * 360F);
		living.method_36456((float) Math.random() * 180F);
	}

	private static void effectHighestPossible(class_1937 level, class_1309 living) {
		int x = class_3532.method_15357(living.method_23317());
		int z = class_3532.method_15357(living.method_23321());
		for (int i = level.method_31600(); i > level.method_31607(); i--) {
			class_2680 state = level.method_8320(new class_2338(x, i, z));
			if (!state.method_26215()) {
				living.method_5859(living.method_23317(), i, living.method_23321());
				break;
			}
		}
	}

	private static void effectDropAllItems(class_1937 level, class_1309 living) {
		if (!level.field_9236 && living instanceof class_1657 player) {
			player.method_31548().method_7388();
		}
	}

	private static void effectHyperspeed(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			living.method_6092(new class_1293(class_1294.field_5904, 60, 200));
		}
	}

	private static void effectNightVision(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			living.method_6092(new class_1293(class_1294.field_5925, 6000, 0));
		}
	}

	private static void effectPixieFriend(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			PixieEntity pixie = new PixieEntity(level);
			pixie.method_5814(living.method_23317(), living.method_23318() + 1.5, living.method_23321());
			level.method_8649(pixie);
		}
	}

	private static void effectNauseaBlindness(class_1937 level, class_1309 living) {
		if (!level.field_9236) {
			living.method_6092(new class_1293(class_1294.field_5916, 160, 3));
			living.method_6092(new class_1293(class_1294.field_5919, 160, 0));
		}
	}

	private static void effectDropOwnHead(class_1937 level, class_1309 living) {
		if (!level.field_9236 && living instanceof class_1657 player) {
			living.method_5643(living.method_48923().method_48831(), living.method_6032() - 1);
			class_1799 skull = new class_1799(class_1802.field_8575);
			ItemNBTHelper.setString(skull, "SkullOwner", player.method_7334().getName());
			living.method_5699(skull, 0);
		}
	}

	private long getSeed(class_1799 stack) {
		long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1);
		if (seed == -1) {
			return randomSeed(stack);
		}
		return seed;
	}

	private long randomSeed(class_1799 stack) {
		long seed = Math.abs(ThreadLocalRandom.current().nextLong());
		ItemNBTHelper.setLong(stack, TAG_SEED, seed);
		return seed;
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		stacks.add(class_2561.method_43471("botaniamisc.bottleTooltip"));
	}

	@NotNull
	@Override
	public class_1799 method_7861(@NotNull class_1799 stack, class_1937 world, class_1309 living) {
		EFFECT_ACTIONS[new Random(getSeed(stack)).nextInt(EFFECT_ACTIONS.length)].apply(world, living);
		int left = getSwigsLeft(stack);
		if (left <= 1) {
			// in case inventory is dropped:
			stack.method_7939(0);
			return new class_1799(class_1802.field_8469);
		} else {
			setSwigsLeft(stack, left - 1);
			randomSeed(stack);
			return stack;
		}
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 20;
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8946;
	}

	public static int getSwigsLeft(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, SWIGS);
	}

	private void setSwigsLeft(class_1799 stack, int swigs) {
		ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
	}

	@FunctionalInterface
	private interface EffectAction {
		void apply(class_1937 level, class_1309 living);
	}
}
