/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class ManaFlameBlockEntity extends BotaniaBlockEntity {
	private static final String TAG_COLOR = "color";

	private int color = 0x20FF20;

	public ManaFlameBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.MANA_FLAME, pos, state);
	}

	public void setColor(int color) {
		this.color = color;
	}

	public int getColor() {
		return color;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_COLOR, color);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		color = cmp.method_10550(TAG_COLOR);
	}

}
