/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.entity;

import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.BabylonWeaponEntity;
import vazkii.botania.common.helper.VecHelper;

import java.util.Random;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public class BabylonWeaponRenderer extends class_897<BabylonWeaponEntity> {

	public BabylonWeaponRenderer(class_5617.class_5618 ctx) {
		super(ctx);
	}

	@Override
	public void render(@NotNull BabylonWeaponEntity weapon, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
		ms.method_22903();
		ms.method_22907(VecHelper.rotateY(weapon.getRotation()));

		int live = weapon.getLiveTicks();
		int delay = weapon.getDelay();
		float charge = Math.min(10F, Math.max(live, weapon.getChargeTicks()) + partialTicks);
		float chargeMul = charge / 10F;

		ms.method_22903();
		ms.method_22904(-0.75, 0, 1); // X shifts the weapon hilt to the center of the circle, Z makes it intersect it.
		float s = 1.5F;
		ms.method_22905(s, s, s);
		ms.method_22907(VecHelper.rotateY(90F)); // Rotate to make it match facing, instead of perpendicular to the circle
		ms.method_22907(VecHelper.rotateZ(-45F)); // Perpendicular to the ground, instead of the rising 45 deg of the sprite

		class_1087 model = MiscellaneousModels.INSTANCE.kingKeyWeaponModels[weapon.getVariety()];
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffers.getBuffer(class_4722.method_29382()), null, model, 1, 1, 1, 0xF000F0, class_4608.field_21444);
		ms.method_22909();

		Random rand = new Random(weapon.method_5667().getMostSignificantBits());
		ms.method_22907(VecHelper.rotateX(-90F)); // Lay the circle horizontally
		ms.method_46416(0F, -0.3F + rand.nextFloat() * 0.1F, 0F); // Randomly offset how deep the item is in the circle

		s = chargeMul;
		if (live > delay) {
			s -= Math.min(1F, (live - delay + partialTicks) * 0.2F);
		}
		s *= 2F;
		ms.method_22905(s, s, s);

		ms.method_22907(VecHelper.rotateY(charge * 9F + (weapon.field_6012 + partialTicks) * 0.5F + rand.nextFloat() * 360F));

		class_4588 buffer = buffers.getBuffer(RenderHelper.BABYLON_ICON);
		Matrix4f mat = ms.method_23760().method_23761();
		buffer.method_22918(mat, -1, 0, -1).method_22915(1, 1, 1, chargeMul).method_22913(0, 0).method_1344();
		buffer.method_22918(mat, -1, 0, 1).method_22915(1, 1, 1, chargeMul).method_22913(0, 1).method_1344();
		buffer.method_22918(mat, 1, 0, 1).method_22915(1, 1, 1, chargeMul).method_22913(1, 1).method_1344();
		buffer.method_22918(mat, 1, 0, -1).method_22915(1, 1, 1, chargeMul).method_22913(1, 0).method_1344();

		ms.method_22909();
	}

	@NotNull
	@Override
	public class_2960 getTextureLocation(@NotNull BabylonWeaponEntity entity) {
		return class_1723.field_21668;
	}

}
