/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.minecraft.class_1799;
import net.minecraft.class_2586;

/**
 * An item that has this capability can contain mana.
 */
public interface ManaItem {

	/**
	 * Gets the amount of mana this item contains
	 */
	int getMana();

	/**
	 * Gets the max amount of mana this item can hold.
	 */
	int getMaxMana();

	/**
	 * Adds mana to this item.
	 */
	void addMana(int mana);

	/**
	 * Can this item receive mana from a mana Pool?
	 * 
	 * @param pool The pool it's receiving mana from, can be casted to ManaPool.
	 * @see ManaPool#isOutputtingPower()
	 */
	boolean canReceiveManaFromPool(class_2586 pool);

	/**
	 * Can this item recieve mana from another item?
	 */
	boolean canReceiveManaFromItem(class_1799 otherStack);

	/**
	 * Can this item export mana to a mana Pool?
	 * 
	 * @param pool The pool it's exporting mana to, can be casted to ManaPool.
	 * @see ManaPool#isOutputtingPower()
	 */
	boolean canExportManaToPool(class_2586 pool);

	/**
	 * Can this item export mana to another item?
	 */
	boolean canExportManaToItem(class_1799 otherStack);

	/**
	 * If this item simply does not export mana at all, set this to true. This is
	 * used to skip items that contain mana but can't export it when drawing the
	 * mana bar above the XP bar.
	 */
	boolean isNoExport();

}
