/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2960;
import net.minecraft.class_4940;

public class SimpleModelSupplierWithOverrides extends class_4940 {
	private final OverrideHolder overrides;

	public SimpleModelSupplierWithOverrides(class_2960 parent, OverrideHolder overrides) {
		super(parent);
		this.overrides = overrides;
	}

	@Override
	public JsonElement method_25839() {
		JsonObject obj = (JsonObject) super.method_25839();
		JsonArray overridesJson = overrides.toJson();
		if (overridesJson != null) {
			obj.add("overrides", overridesJson);
		}
		return obj;
	}
}
