/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.gui.bag.FlowerPouchContainer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class FlowerPouchItem extends class_1792 {
	public static final int DYE_COUNT = 16;
	public static final int SIZE = 2 * DYE_COUNT;

	public FlowerPouchItem(class_1793 props) {
		super(props);
	}

	public static class_1792 getFlowerForSlot(int slot) {
		if (slot < DYE_COUNT) {
			class_1767 color = class_1767.method_7791(slot);
			return BotaniaBlocks.getFlower(color).method_8389();
		} else {
			class_1767 color = class_1767.method_7791(slot - DYE_COUNT);
			return BotaniaBlocks.getDoubleFlower(color).method_8389();
		}
	}

	private static boolean isMysticalFlower(class_1799 stack) {
		Class<? extends class_2248> blockClass = class_2248.method_9503(stack.method_7909()).getClass();
		// Direct class compare needed because glimmering flowers also extend BotaniaFlowerBlock
		// And we might want to add glimmering tall flowers at some point
		return blockClass == BotaniaFlowerBlock.class || blockClass == BotaniaDoubleFlowerBlock.class;
	}

	public static class_1277 getInventory(class_1799 stack) {
		return new ItemBackedInventory(stack, SIZE) {
			@Override
			public boolean method_5437(int slot, @NotNull class_1799 stack) {
				return stack.method_31574(getFlowerForSlot(slot));
			}
		};
	}

	public static boolean onPickupItem(class_1542 entity, class_1657 player) {
		class_1799 entityStack = entity.method_6983();
		class_2248 block = class_2248.method_9503(entityStack.method_7909());
		if (isMysticalFlower(entityStack) && entityStack.method_7947() > 0) {
			int slot;
			if (block instanceof BotaniaDoubleFlowerBlock flower) {
				slot = 16 + flower.color.method_7789();
			} else {
				slot = ((BotaniaFlowerBlock) block).color.method_7789();
			}

			for (int i = 0; i < player.method_31548().method_5439(); i++) {
				if (i == player.method_31548().field_7545) {
					continue; // prevent item deletion
				}

				class_1799 bag = player.method_31548().method_5438(i);
				if (!bag.method_7960() && bag.method_31574(BotaniaItems.flowerBag)) {
					class_1277 bagInv = getInventory(bag);
					class_1799 existing = bagInv.method_5438(slot);
					int newCount = Math.min(existing.method_7947() + entityStack.method_7947(),
							Math.min(existing.method_7914(), bagInv.method_5444()));
					int numPickedUp = newCount - existing.method_7947();

					if (numPickedUp > 0) {
						if (existing.method_7960()) {
							bagInv.method_5447(slot, entityStack.method_7971(numPickedUp));
						} else {
							existing.method_7933(numPickedUp);
							entityStack.method_7934(numPickedUp);
						}
						EntityHelper.syncItem(entity);
						bagInv.method_5431();

						player.method_6103(entity, numPickedUp);

						return true;
					}
				}
			}
		}
		return false;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		if (!world.field_9236) {
			class_1799 stack = player.method_5998(hand);
			XplatAbstractions.INSTANCE.openMenu((class_3222) player, new class_3908() {
				@Override
				public class_2561 method_5476() {
					return stack.method_7964();
				}

				@Override
				public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
					return new FlowerPouchContainer(syncId, inv, stack);
				}
			}, buf -> buf.writeBoolean(hand == class_1268.field_5808));
		}
		return class_1271.method_29237(player.method_5998(hand), world.method_8608());
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2350 side = ctx.method_8038();

		class_2586 tile = world.method_8321(pos);
		if ((ctx.method_8036() == null || ctx.method_8036().method_21823())
				&& XplatAbstractions.INSTANCE.hasInventory(world, pos, side)) {
			if (!world.field_9236) {
				class_1263 bagInv = getInventory(ctx.method_8041());
				for (int i = 0; i < bagInv.method_5439(); i++) {
					class_1799 flower = bagInv.method_5438(i);
					class_1799 rem = XplatAbstractions.INSTANCE.insertToInventory(world, pos, side, flower, false);
					bagInv.method_5447(i, rem);
				}

			}

			return class_1269.method_29236(world.method_8608());
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_33261(@NotNull class_1542 entity) {
		var container = getInventory(entity.method_6983());
		var stream = IntStream.range(0, container.method_5439())
				.mapToObj(container::method_5438)
				.filter(s -> !s.method_7960());
		class_5328.method_33263(entity, stream);
		container.method_5448();
	}

	@Override
	public boolean method_31565(
			@NotNull class_1799 bag, @NotNull class_1735 slot,
			@NotNull class_5536 clickAction, @NotNull class_1657 player) {
		return InventoryHelper.overrideStackedOnOther(
				FlowerPouchItem::getInventory,
				player.field_7512 instanceof FlowerPouchContainer,
				bag, slot, clickAction, player);
	}

	@Override
	public boolean method_31566(
			@NotNull class_1799 bag, @NotNull class_1799 toInsert,
			@NotNull class_1735 slot, @NotNull class_5536 clickAction,
			@NotNull class_1657 player, @NotNull class_5630 cursorAccess) {
		return InventoryHelper.overrideOtherStackedOnMe(
				FlowerPouchItem::getInventory,
				player.field_7512 instanceof FlowerPouchContainer,
				bag, toInsert, clickAction, cursorAccess);
	}
}
