/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class FloralObedienceStickItem extends class_1792 {

	public FloralObedienceStickItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		return applyStick(world, pos)
				? class_1269.method_29236(world.method_8608())
				: class_1269.field_5811;
	}

	public static boolean applyStick(class_1937 world, class_2338 pos) {
		var receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, pos, null);
		if (receiver instanceof ManaPool || receiver instanceof ManaCollector) {
			int range = receiver instanceof ManaPool ? FunctionalFlowerBlockEntity.LINK_RANGE : GeneratingFlowerBlockEntity.LINK_RANGE;

			for (class_2338 iterPos : class_2338.method_10097(pos.method_10069(-range, -range, -range), pos.method_10069(range, range, range))) {
				if (MathHelper.distSqr(iterPos, pos) > range * range) {
					continue;
				}

				class_2586 tile = world.method_8321(iterPos);
				if (tile instanceof BindableSpecialFlowerBlockEntity<?>bindable && bindable.wouldBeValidBinding(pos)) {
					bindable.setBindingPos(pos);
					WandOfTheForestItem.doParticleBeamWithOffset(world, iterPos, pos);
				}
			}

			return true;
		}
		class_2586 tile = world.method_8321(pos);
		if (tile instanceof BindableSpecialFlowerBlockEntity<?>bindableFlower) {
			bindableFlower.setBindingPos(null);
			return true;
		}

		return false;
	}
}
