/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3419;

public class MagicLandmineEntity extends class_1297 {
	public GaiaGuardianEntity summoner;

	public MagicLandmineEntity(class_1299<MagicLandmineEntity> type, class_1937 world) {
		super(type, world);
	}

	@Override
	public void method_5773() {
		method_18799(class_243.field_1353);
		super.method_5773();

		float range = method_17681() / 2;
		float r = 0.2F;
		float g = 0F;
		float b = 0.2F;

		//Proxy.INSTANCE.wispFX(world, getPosX(), getPosY(), getPosZ(), r, g, b, 0.6F, -0.2F, 1);
		for (int i = 0; i < 6; i++) {
			WispParticleData data = WispParticleData.wisp(0.4F, r, g, b, (float) 1);
			method_37908().method_8406(data, method_23317() - range + Math.random() * range * 2, method_23318(), method_23321() - range + Math.random() * range * 2, 0, - -0.015F, 0);
		}

		if (field_6012 >= 55) {
			method_37908().method_43128(null, method_23317(), method_23318(), method_23321(), BotaniaSounds.gaiaTrap, class_3419.field_15254, 1F, 1F);

			float m = 0.35F;
			g = 0.4F;
			for (int i = 0; i < 25; i++) {
				WispParticleData data = WispParticleData.wisp(0.5F, r, g, b);
				method_37908().method_8406(data, method_23317(), method_23318() + 1, method_23321(), (float) (Math.random() - 0.5F) * m, (float) (Math.random() - 0.5F) * m, (float) (Math.random() - 0.5F) * m);
			}

			if (!method_37908().field_9236) {
				List<class_1657> players = method_37908().method_18467(class_1657.class, method_5829());
				for (class_1657 player : players) {
					player.method_5643(this.method_48923().method_48815(this, summoner), 10);
					player.method_6092(new class_1293(class_1294.field_5919, 25, 0));
					class_1293 wither = new class_1293(class_1294.field_5920, 120, 2);
					// wither.getCurativeItems().clear();
					player.method_6092(wither);
				}
			}

			method_31472();
		}
	}

	@Override
	protected void method_5693() {}

	@Override
	protected void method_5749(@NotNull class_2487 var1) {}

	@Override
	protected void method_5652(@NotNull class_2487 var1) {}

	@Override
	public class_2596<class_2602> method_18002() {
		return new class_2604(this);
	}
}
