/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_811;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.StringObfuscator;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.proxy.Proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FlugelTiaraItem extends BaubleItem implements CustomCreativeTabContents {

	private static final class_2960 textureHud = new class_2960(ResourcesLib.GUI_HUD_ICONS);
	public static final class_2960 textureHalo = new class_2960(ResourcesLib.MISC_HALO);

	private static final String TAG_VARIANT = "variant";
	private static final String TAG_FLYING = "flying";
	private static final String TAG_GLIDING = "gliding";
	private static final String TAG_TIME_LEFT = "timeLeft";
	private static final String TAG_INFINITE_FLIGHT = "infiniteFlight";
	private static final String TAG_DASH_COOLDOWN = "dashCooldown";
	private static final String TAG_IS_SPRINTING = "isSprinting";
	private static final String TAG_BOOST_PENDING = "boostPending";

	private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList<>());
	private static final int COST = 35;
	private static final int COST_OVERKILL = COST * 3;
	private static final int MAX_FLY_TIME = 1200;

	private static final int SUBTYPES = 8;
	public static final int WING_TYPES = 9;

	private static final String SUPER_AWESOME_HASH = "4D0F274C5E3001C95640B5E88A821422C8B1E132264492C043A3D746B705C025";

	public FlugelTiaraItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
		for (int i = 0; i < SUBTYPES + 1; i++) {
			class_1799 stack = new class_1799(this);
			ItemNBTHelper.setInt(stack, TAG_VARIANT, i);
			output.method_45420(stack);
		}

	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
		super.method_7851(stack, world, tooltip, flags);
		tooltip.add(class_2561.method_43471("botania.wings" + getVariant(stack)));
	}

	public static void updatePlayerFlyStatus(class_1657 player) {
		class_1799 tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, player);
		int left = ItemNBTHelper.getInt(tiara, TAG_TIME_LEFT, MAX_FLY_TIME);

		if (playersWithFlight.contains(playerStr(player))) {
			if (shouldPlayerHaveFlight(player)) {
				player.method_31549().field_7478 = true;
				if (player.method_31549().field_7479) {
					if (!player.method_37908().field_9236) {
						if (!player.method_7337() && !player.method_7325()) {
							ManaItemHandler.instance().requestManaExact(tiara, player, getCost(tiara, left), true);
						}
					} else if (Math.abs(player.method_18798().method_10216()) > 0.1 || Math.abs(player.method_18798().method_10215()) > 0.1) {
						double x = player.method_23317() - 0.5;
						double y = player.method_23318() - 0.5;
						double z = player.method_23321() - 0.5;

						float r = 1F;
						float g = 1F;
						float b = 1F;

						int variant = getVariant(tiara);
						switch (variant) {
							case 2 -> {
								r = 0.1F;
								g = 0.1F;
								b = 0.1F;
							}
							case 3 -> {
								r = 0F;
								g = 0.6F;
							}
							case 4 -> {
								g = 0.3F;
								b = 0.3F;
							}
							case 5 -> {
								r = 0.6F;
								g = 0F;
								b = 0.6F;
							}
							case 6 -> {
								r = 0.4F;
								g = 0F;
								b = 0F;
							}
							case 7 -> {
								r = 0.2F;
								g = 0.6F;
								b = 0.2F;
							}
							case 8 -> {
								r = 0.85F;
								g = 0.85F;
								b = 0F;
							}
							case 9 -> {
								r = 0F;
								b = 0F;
							}
						}

						for (int i = 0; i < 2; i++) {
							SparkleParticleData data = SparkleParticleData.sparkle(2F * (float) Math.random(), r, g, b, 20);
							player.method_37908().method_8406(data, x + Math.random() * player.method_17681(), y + Math.random() * 0.4, z + Math.random() * player.method_17681(), 0, 0, 0);
						}
					}
				}
			} else {
				if (!player.method_7325() && !player.method_31549().field_7477) {
					player.method_31549().field_7478 = false;
					player.method_31549().field_7479 = false;
					player.method_31549().field_7480 = false;
				}
				playersWithFlight.remove(playerStr(player));
			}
		} else if (shouldPlayerHaveFlight(player)) {
			playersWithFlight.add(playerStr(player));
			player.method_31549().field_7478 = true;
		}
	}

	public static void playerLoggedOut(class_3222 player) {
		String username = player.method_7334().getName();
		playersWithFlight.remove(username + ":false");
		playersWithFlight.remove(username + ":true");
	}

	private static String playerStr(class_1657 player) {
		return player.method_7334().getName() + ":" + player.method_37908().field_9236;
	}

	private static boolean shouldPlayerHaveFlight(class_1657 player) {
		class_1799 armor = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, player);
		if (!armor.method_7960()) {
			int left = ItemNBTHelper.getInt(armor, TAG_TIME_LEFT, MAX_FLY_TIME);
			boolean flying = ItemNBTHelper.getBoolean(armor, TAG_FLYING, false);
			return (left > (flying ? 0 : MAX_FLY_TIME / 10) || InventoryHelper.containsType(player.method_31548(), BotaniaItems.flugelEye)) && ManaItemHandler.instance().requestManaExact(armor, player, getCost(armor, left), false);
		}

		return false;
	}

	public static int getCost(class_1799 stack, int timeLeft) {
		return timeLeft <= 0 ? COST_OVERKILL : COST;
	}

	@Override
	public void onEquipped(class_1799 stack, class_1309 living) {
		super.onEquipped(stack, living);
		int variant = getVariant(stack);
		if (variant != WING_TYPES && StringObfuscator.matchesHash(stack.method_7964().getString(), SUPER_AWESOME_HASH)) {
			ItemNBTHelper.setInt(stack, TAG_VARIANT, WING_TYPES);
			stack.method_7925();
		}
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		if (living instanceof class_1657 player) {
			boolean flying = player.method_31549().field_7479;

			boolean wasSprting = ItemNBTHelper.getBoolean(stack, TAG_IS_SPRINTING, false);
			boolean isSprinting = player.method_5624();
			if (isSprinting != wasSprting) {
				ItemNBTHelper.setBoolean(stack, TAG_IS_SPRINTING, isSprinting);
			}

			int time = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, MAX_FLY_TIME);
			int newTime = time;
			class_243 look = player.method_5720().method_18805(1, 0, 1).method_1029();

			if (flying) {
				if (time > 0 && !player.method_7325() && !player.method_7337()
						&& !ItemNBTHelper.getBoolean(stack, TAG_INFINITE_FLIGHT, false)) {
					newTime--;
				}
				final int maxCd = 80;
				int cooldown = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
				if (!wasSprting && isSprinting && cooldown == 0 && !StoneOfTemperanceItem.hasTemperanceActive(player)) {
					player.method_18799(player.method_18798().method_1031(look.field_1352, 0, look.field_1350));
					player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.dash, class_3419.field_15248, 1F, 1F);
					ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, maxCd);
					ItemNBTHelper.setBoolean(stack, TAG_BOOST_PENDING, true);
				} else if (cooldown > 0) {
					if (ItemNBTHelper.getBoolean(stack, TAG_BOOST_PENDING, false)) {
						living.method_5724(5F, new class_243(0F, 0F, 1F));
						ItemNBTHelper.removeEntry(stack, TAG_BOOST_PENDING);
					}
					ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, cooldown - 2);
				}
			} else {
				boolean wasGliding = ItemNBTHelper.getBoolean(stack, TAG_GLIDING, false);
				boolean doGlide = living.method_5715() && !living.method_24828() && (living.method_18798().method_10214() < -.7F || wasGliding);
				if (time < MAX_FLY_TIME && living.field_6012 % (doGlide ? 6 : 2) == 0) {
					newTime++;
				}

				if (doGlide) {
					float mul = 0.6F;
					living.method_18800(look.field_1352 * mul, Math.max(-0.15F, living.method_18798().method_10214()), look.field_1350 * mul);
					living.field_6017 = 2F;
				}
				ItemNBTHelper.setBoolean(stack, TAG_GLIDING, doGlide);
			}

			ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
			if (newTime != time) {
				ItemNBTHelper.setInt(stack, TAG_TIME_LEFT, newTime);
			}
		}
	}

	@Override
	public boolean hasRender(class_1799 stack, class_1309 living) {
		return super.hasRender(stack, living) && living instanceof class_1657;
	}

	public static class Renderer implements AccessoryRenderer {
		/*
			NB: All of the following methods are somewhat similar, but they are split apart to isolate the logic.
			Trying too hard to factor things out of each case led to very spaghetti-looking code.
			As such, only Jibril's is commented, the rest are variations on the same theme
		*/

		private static void renderBasic(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, int light, float flap) {
			ms.method_22903();

			// attach to body
			bipedModel.field_3391.method_22703(ms);

			// position on body
			ms.method_22904(0, 0.5, 0.2);

			for (int i = 0; i < 2; i++) {
				ms.method_22903();
				ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180 - flap));

				// move so flapping about the edge instead of center of texture
				ms.method_46416(-1, 0, 0);

				// rotate since the textures are stored rotated
				ms.method_22907(VecHelper.rotateZ(-60));
				ms.method_22905(1.5F, -1.5F, -1.5F);
				class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, light, class_4608.field_21444, model);
				ms.method_22909();
			}

			ms.method_22909();
		}

		private static void renderSephiroth(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, int light, float flap) {
			ms.method_22903();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(0, 0.5, 0.2);

			ms.method_22907(VecHelper.rotateY(flap));
			ms.method_22904(-1.1, 0, 0);

			ms.method_22907(VecHelper.rotateZ(-60));
			ms.method_22905(1.6F, -1.6F, -1.6F);
			class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, light, class_4608.field_21444, model);
			ms.method_22909();
		}

		private static void renderCirno(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, int light) {
			ms.method_22903();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(-0.8, 0.15, 0.25);

			for (int i = 0; i < 2; i++) {
				ms.method_22903();

				if (i == 1) {
					ms.method_22907(VecHelper.rotateY(180));
					ms.method_22904(-1.6, 0, 0);
				}

				ms.method_22905(1.6F, -1.6F, -1.6F);
				class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, light, class_4608.field_21444, model);
				ms.method_22909();
			}

			ms.method_22909();
		}

		private static void renderPhoenix(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, float flap) {
			ms.method_22903();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(0, -0.2, 0.2);

			for (int i = 0; i < 2; i++) {
				ms.method_22903();
				ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180 - flap));

				ms.method_22904(-0.9, 0, 0);

				ms.method_22905(1.7F, -1.7F, -1.7F);
				class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, 0xF000F0, class_4608.field_21444, model);
				ms.method_22909();
			}

			ms.method_22909();
		}

		private static void renderKuroyukihime(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, float flap) {
			ms.method_22903();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(0, -0.4, 0.2);

			for (int i = 0; i < 2; i++) {
				ms.method_22903();
				ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180 - flap));

				ms.method_22904(-1.3, 0, 0);

				ms.method_22905(2.5F, -2.5F, -2.5F);
				class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, 0xF000F0, class_4608.field_21444, model);
				ms.method_22909();
			}

			ms.method_22909();
		}

		private static void renderCustomColor(class_572<?> bipedModel, class_1087 model, class_1309 living, class_1799 stack, class_4587 ms, class_4597 buffers, float flap, int color) {
			ms.method_22903();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(0, 0, 0.2);

			for (int i = 0; i < 2; i++) {
				ms.method_22903();
				ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180 - flap));
				ms.method_22904(-0.7, 0, 0);

				ms.method_22905(1.5F, -1.5F, -1.5F);

				RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, 0xF000F0, class_4608.field_21444, model);
				ms.method_22909();
			}

			ms.method_22909();
		}

		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			int meta = getVariant(stack);
			if (meta <= 0 || meta >= MiscellaneousModels.INSTANCE.tiaraWingIcons.length + 1) {
				return;
			}

			class_1087 model = MiscellaneousModels.INSTANCE.tiaraWingIcons[meta - 1];
			boolean flying = living instanceof class_1657 player && player.method_31549().field_7479;
			float flap = 20F + (float) ((Math.sin((double) (living.field_6012 + partialTicks) * (flying ? 0.4F : 0.2F)) + 0.5F) * (flying ? 30F : 5F));

			switch (meta) {
				case 1:
					renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
					ms.method_22903();
					ClientLogic.renderHalo(bipedModel, living, ms, buffers, partialTicks);
					ms.method_22909();
					break;
				case 2:
					renderSephiroth(bipedModel, model, stack, ms, buffers, light, flap);
					break;
				case 3:
					renderCirno(bipedModel, model, stack, ms, buffers, light);
					break;
				case 4:
					renderPhoenix(bipedModel, model, stack, ms, buffers, flap);
					break;
				case 5:
					renderKuroyukihime(bipedModel, model, stack, ms, buffers, flap);
					break;
				case 6:
				case 8:
					renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
					break;
				case 7:
					float alpha = 0.5F + (float) Math.cos((double) (living.field_6012 + partialTicks) * 0.3F) * 0.2F;
					int color = 0xFFFFFF | ((int) (alpha * 255F)) << 24;
					renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
					break;
				case 9:
					flap = -(float) ((Math.sin((double) (living.field_6012 + partialTicks) * 0.2F) + 0.6F) * (flying ? 12F : 5F));
					alpha = 0.5F + (flying ? (float) Math.cos((double) (living.field_6012 + partialTicks) * 0.3F) * 0.25F + 0.25F : 0F);
					color = 0xFFFFFF | ((int) (alpha * 255F)) << 24;
					renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
					break;
			}
		}
	}

	public static class ClientLogic {
		public static void renderHalo(@Nullable class_572<?> model, @Nullable class_1309 living, class_4587 ms, class_4597 buffers, float partialTicks) {
			if (model != null) {
				model.field_3391.method_22703(ms);
			}

			ms.method_22904(0.2, -0.65, 0);
			ms.method_22907(VecHelper.rotateZ(30));

			if (living != null) {
				ms.method_22907(VecHelper.rotateY(living.field_6012 + partialTicks));
			} else {
				ms.method_22907(VecHelper.rotateY(ClientTickHandler.ticksInGame));
			}

			ms.method_22905(0.75F, -0.75F, -0.75F);
			class_4588 buffer = buffers.getBuffer(RenderHelper.HALO);
			Matrix4f mat = ms.method_23760().method_23761();
			buffer.method_22918(mat, -1F, 0, -1F).method_22915(1.0F, 1.0F, 1.0F, 1.0F).method_22913(0, 0).method_1344();
			buffer.method_22918(mat, 1F, 0, -1F).method_22915(1.0F, 1.0F, 1.0F, 1.0F).method_22913(1, 0).method_1344();
			buffer.method_22918(mat, 1F, 0, 1F).method_22915(1.0F, 1.0F, 1.0F, 1.0F).method_22913(1, 1).method_1344();
			buffer.method_22918(mat, -1F, 0, 1F).method_22915(1.0F, 1.0F, 1.0F, 1.0F).method_22913(0, 1).method_1344();
		}

		private static int estimateAdditionalNumRowsRendered(class_1657 player) {
			if (player.method_5777(class_3486.field_15517) || player.method_5669() < player.method_5748()) {
				// shift up single row if player is underwater or still recovering air
				return 1;
			}

			class_1297 playerVehicle = player.method_5854();
			if (playerVehicle instanceof class_1309 vehicle && vehicle.method_5709()) {
				// shift up if vehicle health requires more than one row (vanilla HUD limits vehicle hearts to 3 rows)
				return (Math.min(30, (int) (vehicle.method_6063() + 0.5) / 2) - 1) / 10;
			}

			return 0;
		}

		public static void renderHUD(class_332 gui, class_1657 player, class_1799 stack) {
			int u = Math.max(1, getVariant(stack)) * 9 - 9;
			int v = 0;

			class_310 mc = class_310.method_1551();
			int xo = mc.method_22683().method_4486() / 2 + 10;
			int y = mc.method_22683().method_4502() - 10 * estimateAdditionalNumRowsRendered(player) - 49;

			int left = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, MAX_FLY_TIME);

			int segTime = MAX_FLY_TIME / 10;
			int segs = left / segTime + 1;
			int last = left % segTime;

			for (int i = 0; i < segs; i++) {
				float trans = 1F;
				if (i == segs - 1) {
					trans = (float) last / (float) segTime;
					RenderSystem.enableBlend();
					RenderSystem.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
				}

				RenderSystem.setShaderColor(1F, 1F, 1F, trans);
				RenderHelper.drawTexturedModalRect(gui, textureHud, xo + 8 * i, y, u, v, 9, 9);
			}

			if (player.method_31549().field_7479) {
				int width = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
				RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
				if (width > 0) {
					gui.method_25294(xo, y - 2, xo + 80, y - 1, 0x88000000);
				}
				gui.method_25294(xo, y - 2, xo + width, y - 1, 0xFFFFFFFF);
			}

			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
		}
	}

	public static int getVariant(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_VARIANT, 0);
	}
}
