/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import com.google.common.collect.Iterables;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.DelayHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1472;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3417;

public class SpectrolusBlockEntity extends GeneratingFlowerBlockEntity {
	public static final String TAG_NEXT_COLOR = "nextColor";
	private static final int WOOL_GEN = 1200;
	private static final int SHEEP_GEN = 5000;
	private static final int BABY_SHEEP_GEN = 1; // you are a monster

	private static final int RANGE = 1;

	private class_1767 nextColor = class_1767.field_7952;

	public SpectrolusBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.SPECTROLUS, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		// sheep need to enter the actual block space
		var sheeps = method_10997().method_8390(class_1472.class, new class_238(getEffectivePos()), class_1297::method_5805);

		class_238 itemAABB = new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1));
		Predicate<class_1542> selector = e -> DelayHelper.canInteractWithImmediate(this, e);
		var items = method_10997().method_8390(class_1542.class, itemAABB, selector);

		for (class_1297 target : Iterables.concat(sheeps, items)) {
			if (target instanceof class_1472 sheep) {
				if (!sheep.method_6629() && sheep.method_6633() == nextColor) {
					addManaAndCycle(sheep.method_6109() ? BABY_SHEEP_GEN : SHEEP_GEN);
					float pitch = sheep.method_6109() ? (field_11863.field_9229.method_43057() - field_11863.field_9229.method_43057()) * 0.2F + 1.5F : (field_11863.field_9229.method_43057() - field_11863.field_9229.method_43057()) * 0.2F + 1.0F;
					//Usage of vanilla sound event: this sheep do be dying though. And generic sounds are meant to be reused.
					sheep.method_5783(class_3417.field_14814, 0.9F, pitch);
					sheep.method_5783(class_3417.field_20614, 1, 1);

					class_1799 morbid = new class_1799(sheep.method_5809() ? class_1802.field_8347 : class_1802.field_8748);
					((class_3218) method_10997()).method_14199(new class_2392(class_2398.field_11218, morbid), target.method_23317(), target.method_23318() + target.method_5751(), target.method_23321(), 20, 0.1D, 0.1D, 0.1D, 0.05D);

					class_1799 wool = new class_1799(ColorHelper.WOOL_MAP.apply(sheep.method_6633()));
					((class_3218) method_10997()).method_14199(new class_2392(class_2398.field_11218, wool), target.method_23317(), target.method_23318() + target.method_5751(), target.method_23321(), 20, 0.1D, 0.1D, 0.1D, 0.05D);
				}
				sheep.method_6033(0);
			} else if (target instanceof class_1542 item) {
				class_1799 stack = item.method_6983();

				if (!stack.method_7960() && ColorHelper.isWool(class_2248.method_9503(stack.method_7909()))) {
					class_2248 expected = ColorHelper.WOOL_MAP.apply(nextColor);

					if (expected.method_8389() == stack.method_7909()) {
						addManaAndCycle(WOOL_GEN);
						((class_3218) method_10997()).method_14199(new class_2392(class_2398.field_11218, stack), target.method_23317(), target.method_23318(), target.method_23321(), 20, 0.1D, 0.1D, 0.1D, 0.05D);
					}

					target.method_31472();
				}
			}
		}
	}

	private void addManaAndCycle(int toAdd) {
		addMana(toAdd);
		nextColor = nextColor == class_1767.field_7963 ? class_1767.field_7952 : class_1767.method_7791(nextColor.method_7789() + 1);
		sync();
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return 16000;
	}

	@Override
	public int getColor() {
		return ColorHelper.getColorLegibleOnGrayBackground(nextColor);
	}

	public static class WandHud extends BindableFlowerWandHud<SpectrolusBlockEntity> {
		public WandHud(SpectrolusBlockEntity flower) {
			super(flower);
		}

		@Override
		public void renderHUD(class_332 gui, class_310 mc) {
			class_1799 stack = new class_1799(ColorHelper.WOOL_MAP.apply(flower.nextColor));

			if (stack.method_7960()) {
				super.renderHUD(gui, mc);
			} else {
				int halfWidth = RenderHelper.itemWithNameWidth(mc, stack) / 2;
				int centerY = mc.method_22683().method_4502() / 2;

				super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
				RenderHelper.renderItemWithNameCentered(gui, mc, stack, centerY + 30, ColorHelper.getColorLegibleOnGrayBackground(flower.nextColor));
			}
		}
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_NEXT_COLOR, nextColor.ordinal());
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		nextColor = class_1767.method_7791(cmp.method_10550(TAG_NEXT_COLOR));
	}
}
