/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import com.google.common.collect.Iterables;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;

public class LuminizerLauncherBlock extends BotaniaWaterloggedBlock {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 4, 16);

	public LuminizerLauncherBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_49804(pos) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			pickUpEntities(world, pos);
			world.method_8652(pos, state.method_11657(class_2741.field_12484, true), class_2248.field_31029);
		} else if (!power && powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, false), class_2248.field_31029);
		}
	}

	private void pickUpEntities(class_1937 world, class_2338 pos) {
		List<LuminizerBlockEntity> relays = new ArrayList<>();
		for (class_2350 dir : class_2350.values()) {
			class_2586 tile = world.method_8321(pos.method_10093(dir));
			if (tile instanceof LuminizerBlockEntity relay) {
				if (relay.getNextDestination() != null) {
					relays.add(relay);
				}
			}
		}

		if (!relays.isEmpty()) {
			class_238 aabb = new class_238(pos, pos.method_10069(1, 1, 1));
			var living = world.method_18467(class_1309.class, aabb);
			var items = world.method_18467(class_1542.class, aabb);

			for (class_1297 entity : Iterables.concat(living, items)) {
				LuminizerBlockEntity relay = relays.get(world.field_9229.method_43048(relays.size()));
				relay.mountEntity(entity);
			}
		}
	}

}
